/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.dpr.beansearcher;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.service.util.DataPermissionRuleServiceUtil;
import com.elitescloud.boot.datasecurity.dpr.service.util.RoleDatePermissionColumnUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.BaseDataSecurityRuleDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class BeanSearcherPermissionRuleServiceImpl
implements BeanSearcherPermissionRuleService {
    private static final Logger logger = CloudtBootLoggerFactory.SECURITY_DATA.getLogger(BeanSearcherPermissionRuleServiceImpl.class);
    private final TenantClientProvider tenantClientProvider;

    public BeanSearcherPermissionRuleServiceImpl(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    @Override
    public SysDprRoleApiRowColumnRuleDTO getUserRoleDpr() {
        return DataSecurityUtil.getDataPermission();
    }

    @Override
    public String getBeanSearcherGroupExpr(Map<String, Object> params) {
        return RoleDatePermissionColumnUtil.getBeanSearcherGroupExpr(params);
    }

    @Override
    public void addSetBeanSearcherGroupExpr(Map<String, Object> params, String groupExpr) {
        RoleDatePermissionColumnUtil.addSetBeanSearcherGroupExpr(params, groupExpr);
    }

    @Override
    public MapBuilder tenantAuthSearcherHandleEngine(Class<?> classBean, Map<String, Object> params, String ... pathObj) {
        List columnDto;
        StringBuilder groupAuthExpr = new StringBuilder();
        MapBuilder mapBuilder = MapUtils.builder(params);
        StringBuilder groupTenantExpr = new StringBuilder(RoleDatePermissionColumnUtil.tenantAuthBuilder(this.tenantClientProvider, mapBuilder, params));
        SysDprRoleApiRowColumnRuleDTO roelDprDto = this.getUserRoleDpr();
        List ruleList = roelDprDto == null ? Collections.emptyList() : roelDprDto.getSysDprRoleApiDataRuleListQueryDTO();
        Field[] fields = ReflectUtil.getFields(classBean);
        if (CollUtil.isNotEmpty((Collection)ruleList)) {
            Set<String> fieldNames = Arrays.stream(fields).map(Field::getName).collect(Collectors.toSet());
            String illegalFieldName = this.filterIllegalField(ruleList, fieldNames);
            if (illegalFieldName != null) {
                throw new BusinessException("\u5f02\u5e38\uff1a\u5bf9\u5e94\u7684\u89c4\u5219\u5b57\u6bb5\u5728bean\u4e2d\u4e0d\u5b58\u5728-" + illegalFieldName);
            }
            String ruleGroupExpr = this.ruleAuthBuilder(classBean, mapBuilder, ruleList);
            if (CharSequenceUtil.isNotBlank((CharSequence)ruleGroupExpr)) {
                groupAuthExpr = groupTenantExpr.append("&").append(ruleGroupExpr);
            }
        } else {
            groupAuthExpr = groupTenantExpr;
        }
        if (groupAuthExpr.length() <= 0) {
            throw new RuntimeException("\u6570\u636e\u6743\u9650\u5206\u7ec4\u8868\u8fbe\u5f0f groupAuthExpr is null  ");
        }
        mapBuilder.groupExpr(groupAuthExpr.toString());
        List list = columnDto = roelDprDto == null ? Collections.emptyList() : roelDprDto.getSysDpcRoleApiFieldsDTOList();
        if (columnDto != null && !columnDto.isEmpty()) {
            RoleDatePermissionColumnUtil.setColumnMapBuilder(fields, columnDto, mapBuilder);
        }
        return mapBuilder;
    }

    @Override
    public String ruleAuthBuilder(Class<?> beanClass, MapBuilder mapBuilder, List<SysDprRoleApiDataRuleListQueryDTO> ruleList) {
        StringJoiner joiner = new StringJoiner("|", "(", ")");
        Map<String, List<SysDprRoleApiDataRuleListQueryDTO>> rulesMap = ruleList.stream().collect(Collectors.groupingBy(BaseDataSecurityRuleDTO::getRoleCode));
        AtomicInteger groupStrIndex = new AtomicInteger(0);
        String exp = null;
        for (Map.Entry<String, List<SysDprRoleApiDataRuleListQueryDTO>> entry : rulesMap.entrySet()) {
            DprRuleRelationEnum relation = DataSecurityUtil.getRelation(entry.getValue());
            exp = this.appendAuthExp(beanClass, relation, entry.getValue(), mapBuilder, groupStrIndex);
            if (exp == null) continue;
            joiner.add(exp);
        }
        return joiner.toString();
    }

    private String appendAuthExp(Class<?> beanClass, DprRuleRelationEnum relation, List<SysDprRoleApiDataRuleListQueryDTO> ruleList, MapBuilder mapBuilder, AtomicInteger groupStrIndex) {
        if (CollUtil.isEmpty(ruleList)) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(relation == DprRuleRelationEnum.DPR_RULE_RELATION_OR ? "|" : "&", "(", ")");
        String exp = null;
        boolean sqlEmpty = true;
        for (SysDprRoleApiDataRuleListQueryDTO rule : ruleList) {
            if (Boolean.TRUE.equals(rule.getRuleGroup())) {
                exp = this.appendAuthExp(beanClass, DprRuleRelationEnum.valueOf(rule.getDprRuleRelation()), rule.getGroupRules(), mapBuilder, groupStrIndex);
                if (exp == null) continue;
                joiner.add(exp);
                sqlEmpty = false;
                continue;
            }
            if ("DPR_SYS_INTERNALLY_ALL".equals(rule.getDprRuleValue())) {
                joiner.add(DprRuleConditionEnum.Equal.name().equals(rule.getDprRuleCondition()) || DprRuleConditionEnum.InList.name().equals(rule.getDprRuleCondition()) ? "1=1" : "1<>1");
                sqlEmpty = false;
                continue;
            }
            if (beanClass != null && ReflectUtil.getField(beanClass, (String)rule.getDprRuleField()) == null) continue;
            String gStr = RoleDatePermissionColumnUtil.GROUP_STR[groupStrIndex.getAndIncrement()];
            mapBuilder.group(gStr);
            joiner.add(gStr);
            sqlEmpty = false;
            DataPermissionRuleServiceUtil.dprRuleValueTypeMapBuilder(mapBuilder, rule);
        }
        if (sqlEmpty) {
            return null;
        }
        return joiner.toString();
    }

    @Override
    public MapBuilder tenantSearcherHandleEngine(Class<?> beanClass, Map<String, Object> paraMap, String ... pathObj) {
        MapBuilder mapBuilder = MapUtils.builder(paraMap);
        StringBuilder groupExpr = new StringBuilder(RoleDatePermissionColumnUtil.tenantBuilder(this.tenantClientProvider, mapBuilder, paraMap));
        return mapBuilder;
    }

    private String filterIllegalField(List<SysDprRoleApiDataRuleListQueryDTO> ruleList, Set<String> fieldNames) {
        if (CollUtil.isEmpty(ruleList)) {
            return null;
        }
        String illegalField = null;
        for (SysDprRoleApiDataRuleListQueryDTO rule : ruleList) {
            if (Boolean.TRUE.equals(rule.getRuleGroup())) {
                illegalField = this.filterIllegalField(rule.getGroupRules(), fieldNames);
                if (illegalField == null) continue;
                return illegalField;
            }
            if (fieldNames.contains(rule.getDprRuleField())) continue;
            return rule.getDprRuleField();
        }
        return null;
    }
}

