package com.elitescloud.boot.dubbo.config.handler;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.exception.CustomExceptionTranslate;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.rpc.RpcException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

/**
 * dubbo相关异常翻译.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/3
 */
public class DubboExceptionTranslate implements CustomExceptionTranslate {

    private static final String EXP_NO_PROVIDER_AVAILABLE = "No provider available";
    private static final String EXP_NO_PROVIDER_AVAILABLE1 = "because channel is closed";
    private static final String EXP_THREAD_POOL_OVERFLOW = "thread pool is exhausted";

    @Override
    public boolean support(@NonNull Throwable e) {
        return e instanceof RpcException;
    }

    @Override
    @Nullable
    public ApiResult<String> translate(@NonNull Throwable e) {
        RpcException exception = (RpcException) e;

        var rootCause = ExceptionUtil.getRootCause(exception);
        if (rootCause instanceof TimeoutException) {
            return ApiResult.fail(ApiCode.REQUEST_TIMEOUT, "请求超时");
        }

        var rootCauseMsg = rootCause.getMessage();
        if (CharSequenceUtil.contains(rootCauseMsg, EXP_NO_PROVIDER_AVAILABLE) || CharSequenceUtil.contains(rootCauseMsg, EXP_NO_PROVIDER_AVAILABLE1)) {
            return ApiResult.fail(ApiCode.NO_PROVIDER, "系统维护中，请稍后再试");
        }
        if (CharSequenceUtil.contains(rootCauseMsg, EXP_THREAD_POOL_OVERFLOW)) {
            return ApiResult.fail(ApiCode.THREAD_POOL_OVERFLOW, "当前访问用户过多，请稍后再试");
        }
        return ApiResult.fail(ApiCode.PROVIDER_EXCEPTION);
    }
}
