package com.elitescloud.boot.dubbo.filter;

import com.elitescloud.cloudt.common.constant.CommonConstant;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.*;
import org.slf4j.MDC;

/**
 * dubbo 链路日志跟踪处理.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/23
 */
@Activate(group = {CommonConstants.PROVIDER, CommonConstants.CONSUMER})
public class DubboTraceLogFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcContext rpcContext = RpcContext.getContext();
        if (rpcContext.getUrl() == null) {
            return invoker.invoke(invocation);
        }

        String traceId = null;
        if (rpcContext.isProviderSide()) {
            // 服务端的话从消费端传递的参数中获取
            traceId = rpcContext.getAttachment(CommonConstant.LOG_TRACE_ID);
            if (traceId != null && traceId.trim().length() > 0) {
                MDC.put(CommonConstant.LOG_TRACE_ID, traceId);
            }
        } else {
            // 消费端，将自己的传递过去
            traceId = MDC.get(CommonConstant.LOG_TRACE_ID);
            if (traceId != null && traceId.trim().length() > 0) {
                rpcContext.setAttachment(CommonConstant.LOG_TRACE_ID, traceId);
            }
        }

        return invoker.invoke(invocation);
    }
}
