/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.dubbo.filter;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.util.Collections;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.slf4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Activate(group={"consumer", "provider"}, order=0x7FFFFFFF)
public class DubboAuthenticationContextFilter
implements Filter {
    private static final Logger logger = CloudtBootLoggerFactory.RPC_DUBBO.getLogger(DubboAuthenticationContextFilter.class);
    private JwtDecoder jwtDecoder;

    public Result invoke(Invoker<?> invoker, Invocation invocation) {
        RpcServiceContext rpcContext = RpcContext.getServiceContext();
        if (rpcContext.getUrl() == null) {
            return invoker.invoke(invocation);
        }
        try {
            if (rpcContext.isConsumerSide()) {
                this.transportAuthentication((RpcContext)rpcContext);
            } else {
                this.obtainAuthentication((RpcContext)rpcContext);
            }
            Result result = invoker.invoke(invocation);
            return result;
        }
        catch (Exception e) {
            logger.error("DubboAuditFilter \u5f02\u5e38:" + e.getMessage());
            throw e;
        }
        finally {
            if (rpcContext.isProviderSide()) {
                SecurityContextHolder.clearContext();
            }
        }
    }

    private void transportAuthentication(RpcContext rpcContext) {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null || user.getUser() == null) {
            logger.warn("\u8c03\u7528dubbo\u65f6\u4f20\u9012\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f");
            return;
        }
        if (user.getUser() != null) {
            String token;
            rpcContext.setObjectAttachment("current_user_id", (Object)user.getUser().getId().toString());
            rpcContext.setObjectAttachment("current_user_name", (Object)user.getUser().getUsername());
            if (user.getTenant() != null) {
                rpcContext.setObjectAttachment("X-Tenant-Id", (Object)user.getTenant().getId().toString());
            }
            if (StringUtils.hasText((String)(token = SecurityContextUtil.currentToken()))) {
                rpcContext.setAttachment("current_auth_token", token);
            }
        }
    }

    private void obtainAuthentication(RpcContext rpcContext) {
        String token = rpcContext.getAttachment("current_auth_token");
        if (!StringUtils.hasText((String)token)) {
            return;
        }
        if (this.jwtDecoder == null) {
            this.jwtDecoder = (JwtDecoder)SpringContextHolder.getBean(JwtDecoder.class);
            Assert.notNull((Object)this.jwtDecoder, (String)"\u89e3\u6790token\u5931\u8d25\uff0cjwtDecoder\u4e0d\u5b58\u5728");
        }
        Jwt jwt = this.jwtDecoder.decode(token);
        JwtAuthenticationToken authenticationToken = new JwtAuthenticationToken(jwt, Collections.emptyList());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
    }
}

