/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.dubbo.filter;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.MDC;

@Activate(group={"provider", "consumer"})
public class DubboTraceLogFilter
implements Filter {
    private static final Logger logger = CloudtBootLoggerFactory.RPC_DUBBO.getLogger(DubboTraceLogFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcContext rpcContext = RpcContext.getContext();
        if (rpcContext.getUrl() == null) {
            return invoker.invoke(invocation);
        }
        String traceId = null;
        if (rpcContext.isProviderSide()) {
            traceId = rpcContext.getAttachment("cloudt_traceId");
            if (traceId != null && traceId.trim().length() > 0) {
                MDC.put((String)"cloudt_traceId", (String)traceId);
            }
        } else {
            traceId = MDC.get((String)"cloudt_traceId");
            if (traceId != null && traceId.trim().length() > 0) {
                rpcContext.setAttachment("cloudt_traceId", traceId);
            }
        }
        return invoker.invoke(invocation);
    }
}

