/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.dubbo.filter;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.exception.BusinessException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.validation.Validation;
import org.apache.dubbo.validation.Validator;
import org.slf4j.Logger;

@Activate(group={"consumer", "provider"}, value={"validation"}, order=9999)
public class DubboValidationFilter
implements Filter {
    private static final Logger logger = CloudtBootLoggerFactory.RPC_DUBBO.getLogger(DubboValidationFilter.class);
    private Validation validation;

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (this.validation != null && !invocation.getMethodName().startsWith("$") && ConfigUtils.isNotEmpty((String)invoker.getUrl().getMethodParameter(invocation.getMethodName(), "validation"))) {
            try {
                Validator validator = this.validation.getValidator(invoker.getUrl());
                if (validator != null) {
                    validator.validate(invocation.getMethodName(), invocation.getParameterTypes(), invocation.getArguments());
                }
            }
            catch (RpcException e) {
                logger.error("\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3\u5931\u8d25", (Throwable)e);
                throw new BusinessException("\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (Throwable)e);
            }
            catch (ValidationException e) {
                logger.error("dubbo\u5f02\u5e38\uff1a", (Throwable)e);
                if (e instanceof ConstraintViolationException) {
                    String msg = ((ConstraintViolation[])((ConstraintViolationException)e).getConstraintViolations().toArray(ConstraintViolation[]::new))[0].getMessage();
                    return AsyncRpcResult.newDefaultAsyncResult((Throwable)new ValidationException(msg), (Invocation)invocation);
                }
                return AsyncRpcResult.newDefaultAsyncResult((Throwable)new ValidationException("\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3\u5931\u8d25\uff0c\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7"), (Invocation)invocation);
            }
            catch (Exception t) {
                logger.error("dubbo\u5f02\u5e38\uff1a", (Throwable)t);
                return AsyncRpcResult.newDefaultAsyncResult((Throwable)t, (Invocation)invocation);
            }
        }
        return invoker.invoke(invocation);
    }
}

