/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.dubbo.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.bootstrap.builders.ReferenceBuilder;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.nacos.NacosNamingServiceWrapper;
import org.apache.dubbo.registry.nacos.NacosRegistry;
import org.apache.dubbo.registry.nacos.util.NacosNamingServiceUtils;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.slf4j.Logger;

public abstract class DubboNacosHolder {
    private static final Logger logger = CloudtBootLoggerFactory.RPC_DUBBO.getLogger(DubboNacosHolder.class);

    public static List<RegistryConfig> getRegistryConfig() {
        return new ArrayList<RegistryConfig>(DubboBootstrap.getInstance().getConfigManager().getRegistries());
    }

    public static List<Registry> getRegistries() {
        return new ArrayList<Registry>(RegistryManager.getInstance((ApplicationModel)DubboBootstrap.getInstance().getApplicationModel()).getRegistries());
    }

    public static NacosRegistry getRegistryOfNacos() {
        List<Registry> registries = DubboNacosHolder.getRegistries();
        if (registries.isEmpty()) {
            return null;
        }
        for (Registry registry : registries) {
            if (!(registry instanceof NacosRegistry)) continue;
            return (NacosRegistry)registry;
        }
        return null;
    }

    public static NacosNamingServiceWrapper getNacosNamingServiceWrapper() {
        NacosRegistry registry = DubboNacosHolder.getRegistryOfNacos();
        if (registry == null) {
            logger.warn("\u672a\u83b7\u53d6\u5230NacosRegistry");
            return null;
        }
        URL registryUrl = registry.getUrl();
        return NacosNamingServiceUtils.createNamingService((URL)registryUrl);
    }

    public static String buildServiceName(String category, Class<?> serviceInterface, String version) {
        return (String)Assert.notBlank((CharSequence)category) + ":" + serviceInterface.getName() + ":" + CharSequenceUtil.blankToDefault((CharSequence)version, (String)"") + ":";
    }

    public static List<Instance> queryNacosInstance(String serviceName, String group) throws NacosException {
        NacosNamingServiceWrapper nacosNamingServiceWrapper;
        if (CharSequenceUtil.isBlank((CharSequence)group)) {
            group = SpringContextHolder.getProperty((String)"dubbo.registry.group", (String)"DEFAULT_GROUP");
        }
        if ((nacosNamingServiceWrapper = DubboNacosHolder.getNacosNamingServiceWrapper()) == null) {
            logger.warn("\u672a\u83b7\u53d6\u5230NacosNamingServiceWrapper");
            return Collections.emptyList();
        }
        return nacosNamingServiceWrapper.getAllInstances(serviceName, group);
    }

    public static Map<String, List<Instance>> queryNacosInstanceForApplication(String serviceName, String group) throws NacosException {
        List<Instance> instances = DubboNacosHolder.queryNacosInstance(serviceName, group);
        if (instances.isEmpty()) {
            return Collections.emptyMap();
        }
        return instances.stream().collect(Collectors.groupingBy(t -> t.getMetadata().getOrDefault("application", "unknown")));
    }

    public static <T> T getInstanceOfSpecial(Class<T> serviceInterface, String version, Instance instance) {
        return DubboNacosHolder.getInstanceOfSpecial(serviceInterface, version, instance, null);
    }

    public static <T> T getInstanceOfSpecial(Class<T> serviceInterface, String version, Instance instance, Integer timeout) {
        ReferenceBuilder referenceBuilder = ((ReferenceBuilder)((ReferenceBuilder)ReferenceBuilder.newBuilder().interfaceClass(serviceInterface).version(version)).timeout(timeout)).url("dubbo://" + instance.getIp() + ":" + instance.getPort());
        if (timeout != null) {
            referenceBuilder.timeout(timeout);
        }
        return (T)referenceBuilder.build().get();
    }
}

