/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl;

import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.excel.common.support.ExportedDataFormatter;
import com.elitescloud.boot.excel.common.support.TmplApiService;
import com.elitescloud.boot.excel.config.ExcelProperties;
import com.elitescloud.boot.excel.config.tmpl.DataExportServiceFactory;
import com.elitescloud.boot.excel.config.tmpl.DataImportServiceFactory;
import com.elitescloud.boot.excel.config.tmpl.TmplDataController;
import com.elitescloud.boot.excel.config.tmpl.TmplDataService;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.TmplExportStrategyDelegate;
import com.elitescloud.boot.excel.support.FieldPermissionExportedDataFormatter;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;

@Import(value={DataSecurityConfig.class})
@ConditionalOnClass(value={FileService.class})
public class TmplConfig {
    private final TmplApiService tmplApiService;
    private final RedisUtils redisUtils;
    private final FileService<?> fileService;

    public TmplConfig(TmplApiService tmplApiService, RedisUtils redisUtils, FileService<?> fileService) {
        this.tmplApiService = tmplApiService;
        this.redisUtils = redisUtils;
        this.fileService = fileService;
    }

    @Bean
    SystemTmplDataSupport systemTmplDataSupport() {
        return new SystemTmplDataSupport(this.tmplApiService, this.redisUtils, this.fileService);
    }

    @Bean
    DataImportServiceFactory systemDataImportServiceFactory(ObjectProvider<DataImport<?>> dataImportProvider) {
        List<DataImport<?>> dataImportList = dataImportProvider.stream().collect(Collectors.toList());
        return new DataImportServiceFactory(dataImportList);
    }

    @Bean
    DataExportServiceFactory systemDataExportServiceFactory(ObjectProvider<DataExport<? extends Serializable, ? extends AbstractOrderQueryParam>> dataExportProvider) {
        List<DataExport<?, ?>> dataExportList = dataExportProvider.stream().collect(Collectors.toList());
        return new DataExportServiceFactory(dataExportList);
    }

    @Bean
    TmplDataService tmplDataService(ExcelProperties excelProperties, SystemTmplDataSupport systemTmplDataSupport, DataImportServiceFactory dataImportServiceFactory, DataExportServiceFactory dataExportServiceFactory, TmplExportStrategyDelegate exportStrategyDelegate, TaskExecutor taskExecutor, ObjectMapper objectMapper, List<ExportedDataFormatter> exportedDataFormatters) {
        return new TmplDataService(excelProperties, this.fileService, systemTmplDataSupport, dataImportServiceFactory, dataExportServiceFactory, exportStrategyDelegate, taskExecutor, objectMapper, exportedDataFormatters);
    }

    @Bean
    TmplDataController tmplDataController(TmplDataService tmplDataService) {
        return new TmplDataController(tmplDataService);
    }

    @Bean
    TmplExportStrategyDelegate tmplExportStrategyDelegate(SystemTmplDataSupport fsmTmplSupport) {
        return new TmplExportStrategyDelegate(this.fileService, fsmTmplSupport);
    }

    @ConditionalOnClass(value={DataSecurityUtil.class})
    static class DataSecurityConfig {
        DataSecurityConfig() {
        }

        @Bean
        @ConditionalOnProperty(prefix="elitesland.data-security", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public FieldPermissionExportedDataFormatter fieldPermissionExportedDataFormatter() {
            return new FieldPermissionExportedDataFormatter();
        }
    }
}

