/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl.converter;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitescloud.boot.excel.common.support.CustomConverter;

class BooleanConverter
implements CustomConverter<Boolean> {
    private static final String Y = "\u662f";
    private static final String N = "\u5426";

    BooleanConverter() {
    }

    public Class<Boolean> supportJavaTypeKey() {
        return Boolean.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Boolean convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String strValue = cellData.getDataFormatString();
        if (CharSequenceUtil.isBlank((CharSequence)strValue)) {
            return null;
        }
        switch (strValue = strValue.toLowerCase()) {
            case "\u662f": 
            case "true": {
                return true;
            }
        }
        return false;
    }

    public CellData<String> convertToExcelData(Boolean value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if (value == null) {
            return new CellData("");
        }
        return new CellData(value != false ? Y : N);
    }
}

