/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.poi.excel.RowUtil;
import cn.hutool.poi.excel.cell.CellUtil;
import cn.hutool.poi.excel.style.StyleUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.elitescloud.boot.common.annotation.BigDecimalFormat;
import com.elitescloud.boot.excel.config.tmpl.converter.ConverterFactory;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.DataFormatterProvider;
import com.elitescloud.boot.util.BeanWrapperUtil;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public final class ExcelUtil
extends cn.hutool.poi.excel.ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    private static final Logger LOG = LoggerFactory.getLogger(ExcelUtil.class);
    private static List<Converter<?>> converters;

    private ExcelUtil() {
    }

    public static void copyRows(@NonNull Sheet source, @NonNull Sheet target, int startIndex, int endIndex) {
        ExcelUtil.copyRows(source, target, startIndex, endIndex, null);
    }

    public static void copyRows(@NonNull Sheet source, @NonNull Sheet target, int startIndex, int endIndex, Set<Integer> ignoredRowIndexes) {
        Assert.isTrue((endIndex >= startIndex ? 1 : 0) != 0, (String)"endIndex\u5fc5\u987b\u5927\u4e8estartIndex");
        int startRowNum = source.getFirstRowNum();
        int endRowNum = source.getLastRowNum();
        if (startIndex > endRowNum || endIndex < startRowNum) {
            LOG.warn("\u6ca1\u6709\u53ef\u590d\u5236\u7684\u884c\u6570\uff1a{}-{}, {}-{}", new Object[]{startIndex, endIndex, startRowNum, endRowNum});
            return;
        }
        int maxColNum = 0;
        block2: for (int i = startIndex; i <= endIndex; ++i) {
            int colNum;
            if (ignoredRowIndexes != null && ignoredRowIndexes.contains(i)) continue;
            Row sourceRow = source.getRow(i);
            int n = colNum = sourceRow == null ? -1 : (int)sourceRow.getLastCellNum();
            if (colNum < 1) continue;
            Row targetRow = RowUtil.getOrCreateRow((Sheet)target, (int)i);
            targetRow.setHeightInPoints(sourceRow.getHeightInPoints());
            int numOfEmptyCell = 0;
            for (int j = sourceRow.getFirstCellNum(); j < colNum; ++j) {
                boolean isEmpty;
                Cell sourceCell;
                if (i == startIndex) {
                    target.setColumnWidth(j, source.getColumnWidth(j));
                }
                if ((sourceCell = sourceRow.getCell(j)) == null) {
                    if (j < maxColNum) continue block2;
                    maxColNum = j;
                    continue block2;
                }
                boolean bl = isEmpty = sourceCell.getCellTypeEnum() == CellType.BLANK;
                if (isEmpty) {
                    if (j >= maxColNum && ++numOfEmptyCell >= 5) {
                        maxColNum = j;
                        continue block2;
                    }
                } else {
                    numOfEmptyCell = 0;
                }
                Cell targetCell = CellUtil.getOrCreateCell((Row)targetRow, (int)j);
                try {
                    ExcelUtil.copyCell(sourceCell, targetCell);
                    continue;
                }
                catch (Exception e) {
                    throw new BusinessException("\u5904\u7406\u6570\u636e\u5931\u8d25\uff0c\u7b2c" + (i + 1) + "\u884c\u7b2c" + (j + 1) + "\u5217", (Throwable)e);
                }
            }
        }
    }

    public static void copyCell(@NonNull Cell source, @NonNull Cell target) {
        target.setCellStyle(StyleUtil.cloneCellStyle((Cell)target, (CellStyle)source.getCellStyle()));
        CellType cellType = source.getCellTypeEnum();
        switch (cellType) {
            case STRING: {
                target.setCellValue(source.getStringCellValue());
                break;
            }
            case NUMERIC: {
                target.setCellValue(source.getNumericCellValue());
                break;
            }
            case _NONE: {
                break;
            }
            case BLANK: {
                break;
            }
            case ERROR: {
                target.setCellErrorValue(source.getErrorCellValue());
                break;
            }
            case BOOLEAN: {
                target.setCellValue(source.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                target.setCellFormula(source.getCellFormula());
                break;
            }
            default: {
                target.setCellValue(source.getStringCellValue());
            }
        }
    }

    public static ObjectMapper buildObjectMapper() {
        Jackson2ObjectMapperBuilder objectMapperBuilder = ObjectMapperFactory.builderInstance();
        objectMapperBuilder.serializerByType(Long.class, (JsonSerializer)new NumberSerializers.LongSerializer(Long.class));
        objectMapperBuilder.serializerByType(Long.TYPE, (JsonSerializer)new NumberSerializers.LongSerializer(Long.TYPE));
        return objectMapperBuilder.build();
    }

    public static ExcelWriterBuilder normalizeExcelWriter(ExcelWriterBuilder writerBuilder) {
        ((ExcelWriterBuilder)((ExcelWriterBuilder)writerBuilder.useDefaultStyle(Boolean.valueOf(true))).autoTrim(Boolean.valueOf(true))).writeExcelOnException(Boolean.valueOf(true));
        for (Converter<?> converter : ExcelUtil.getConverters()) {
            writerBuilder.registerConverter(converter);
        }
        return writerBuilder;
    }

    public static Object formatExportedValue(Object value, String field, Class<?> dataType) {
        if (value == null || CharSequenceUtil.isBlank((CharSequence)field) || dataType == null) {
            return value;
        }
        if (value instanceof String) {
            return CharSequenceUtil.subPre((CharSequence)value.toString(), (int)SpreadsheetVersion.EXCEL2007.getMaxTextLength());
        }
        if (value instanceof BigDecimal) {
            BigDecimalFormat bigDecimalFormat = (BigDecimalFormat)BeanWrapperUtil.getAnnotation(dataType, (String)field, BigDecimalFormat.class);
            return DataFormatterProvider.getInstance().format((BigDecimal)value, bigDecimalFormat);
        }
        return value;
    }

    public static List<Converter<?>> getConverters() {
        if (converters == null) {
            converters = ConverterFactory.getConvertersAll();
        }
        return converters;
    }
}

