/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl;

import com.elitescloud.boot.common.param.FileInfoVO;
import com.elitescloud.boot.excel.common.param.ImportRecordRespVO;
import com.elitescloud.boot.excel.config.tmpl.TmplDataService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.ExportResultRespVO;
import com.elitescloud.cloudt.system.dto.resp.ImportRateRespVO;
import com.elitescloud.cloudt.system.dto.resp.ImportResultRespVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.http.HttpEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Api(tags={"\u6570\u636e\u6a21\u677f\u5bfc\u5165\u5bfc\u51fa"})
@ResponseBody
@RequestMapping(value={"/cloudt/core/import"}, produces={"application/json"})
@Validated
public class TmplDataController {
    private final TmplDataService service;

    public TmplDataController(TmplDataService service) {
        this.service = service;
    }

    @GetMapping(value={"/{tmplCode}/tmpl"}, produces={"application/octet-stream"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6")
    @ApiOperationSupport(order=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="tmplCode", value="\u6a21\u677f\u7f16\u53f7", required=true, paramType="path")})
    public HttpEntity<StreamingResponseBody> downloadTmpl(@PathVariable(value="tmplCode") String tmplCode) {
        return this.service.downloadByCode(tmplCode);
    }

    @PostMapping(value={"/{tmplCode}/data"})
    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u5bfc\u5165\u6570\u636e")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="tmplCode", value="\u6a21\u677f\u7f16\u53f7", required=true, paramType="path"), @ApiImplicitParam(name="file", value="\u6570\u636e\u6587\u4ef6", required=true, paramType="form", dataTypeClass=MultipartFile.class)})
    public ApiResult<ImportResultRespVO> importData(@PathVariable(value="tmplCode") String tmplCode, @NotNull(message="\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a") @NotNull(message="\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a") MultipartFile file) {
        return this.service.importData(tmplCode, file);
    }

    @PostMapping(value={"/{tmplCode}/export"}, consumes={"application/json"})
    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u5bfc\u51fa\u6570\u636e")
    @ApiOperationSupport(order=3)
    @ApiImplicitParams(value={@ApiImplicitParam(name="tmplCode", value="\u6a21\u677f\u7f16\u53f7", required=true, paramType="path"), @ApiImplicitParam(name="queryParam", value="\u67e5\u8be2\u53c2\u6570", paramType="body", dataType="map")})
    public ApiResult<ExportResultRespVO> exportData(@PathVariable(value="tmplCode") String tmplCode, @RequestBody(required=false) Map<String, Object> queryParam) {
        return this.service.exportData(tmplCode, queryParam);
    }

    @GetMapping(value={"/export/{recordId}/file"}, produces={"application/octet-stream"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u51fa\u7684\u6570\u636e\u6587\u4ef6")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="recordId", value="\u5bfc\u51fa\u8bb0\u5f55ID", required=true)})
    public HttpEntity<StreamingResponseBody> downloadExportFile(@PathVariable(value="recordId") Long recordId) {
        return this.service.downloadExportFile(recordId);
    }

    @GetMapping(value={"/export/{recordId}/fileUrl"})
    @ApiOperation(value="\u83b7\u53d6\u5bfc\u51fa\u7684\u6570\u636e\u6587\u4ef6\u5730\u5740")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="recordId", value="\u5bfc\u51fa\u8bb0\u5f55ID", required=true)})
    public ApiResult<FileInfoVO> getExportFile(@PathVariable(value="recordId") Long recordId) {
        return this.service.getExportFileUrl(recordId);
    }

    @GetMapping(value={"/{recordId}/rate"})
    @ApiOperation(value="\u67e5\u8be2\u5bfc\u5165\uff08\u6216\u5bfc\u51fa\uff09\u8fdb\u5ea6")
    @ApiOperationSupport(order=5)
    @ApiImplicitParams(value={@ApiImplicitParam(name="recordId", value="\u8bb0\u5f55\u6807\u8bc6", required=true)})
    public ApiResult<ImportRateRespVO> getRate(@PathVariable(value="recordId") Long recordId) {
        return this.service.getRate(recordId);
    }

    @ApiOperation(value="\u67e5\u8be2\u6700\u8fd1\u7684\u5bfc\u5165\u8bb0\u5f55")
    @ApiOperationSupport(order=6)
    @ApiImplicitParams(value={@ApiImplicitParam(name="tmplCode", value="\u6a21\u677f\u7f16\u7801", required=true), @ApiImplicitParam(name="hours", value="\u6700\u8fd1\u65f6\u95f4\uff08\u5c0f\u65f6\u6570\u91cf\uff09", defaultValue="72"), @ApiImplicitParam(name="self", value="\u662f\u5426\u4ec5\u67e5\u81ea\u5df1\u7684", defaultValue="true")})
    @GetMapping(value={"/record/recently"})
    public ApiResult<List<ImportRecordRespVO>> queryRecord(@RequestParam(value="tmplCode") @NotBlank(message="\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a") String tmplCode, @RequestParam(name="hours", required=false, defaultValue="72") Integer hours, @RequestParam(name="self", required=false, defaultValue="true") Boolean self) {
        return this.service.queryRecord(tmplCode, hours, self);
    }
}

