/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.support.export.strategy;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.excel.support.export.ExportContextParam;
import com.elitescloud.boot.excel.support.export.ExportDataStrategy;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

abstract class BaseExportDataStrategy
implements ExportDataStrategy {
    private static final Logger logger = CloudtBootLoggerFactory.EXCEL_EXPORT.getLogger(BaseExportDataStrategy.class);
    protected final ExportContextParam contextParam;
    protected int sheetDataLimit;

    public BaseExportDataStrategy(ExportContextParam contextParam) {
        this.contextParam = contextParam;
    }

    @Override
    public void initialize() {
        this.sheetDataLimit = this.getSheetDataLimit();
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    abstract void doWrite(List<List<Object>> var1);

    @Override
    public void writeData(List<List<Object>> dataList) {
        this.doWrite(dataList);
    }

    @Override
    public File exportToFile() {
        return null;
    }

    protected WriteSheet createSheet(int sheetIndex) {
        ExcelWriterSheetBuilder sheetBuilder = EasyExcel.writerSheet((Integer)sheetIndex).sheetName("Sheet " + (sheetIndex + 1));
        if (this.contextParam.isFieldFromTmpl()) {
            sheetBuilder.relativeHeadRowIndex(Integer.valueOf(this.contextParam.getTmplDTO().getHeadRow() - 1));
        } else {
            sheetBuilder.head(this.contextParam.getTmplDTO().getAttributeTitles().stream().map(List::of).collect(Collectors.toList()));
        }
        return sheetBuilder.build();
    }

    protected int getSheetDataLimit() {
        Integer limit = this.contextParam.getTmplDTO().getExportSheetLimit();
        if (limit == null) {
            return 1000000;
        }
        if (limit > 0 && limit <= 1000000) {
            return limit;
        }
        throw new IllegalArgumentException(CharSequenceUtil.blankToDefault((CharSequence)this.contextParam.getTmplCode(), (String)"") + "sheet\u9875\u6570\u636e\u91cf\u53c2\u6570" + limit + "\u4e0d\u5408\u6cd5\uff0c\u53d6\u503c\u8303\u56f41~1000000");
    }
}

