/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.flyway;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.flyway.FlywayCloudtProperties;
import com.elitescloud.boot.flyway.common.FlywayBuilder;
import com.elitescloud.boot.flyway.common.FlywayHelper;
import com.elitescloud.cloudt.context.util.database.DatasourceLoadUtil;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="elitesland.flyway", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={FlywayCloudtProperties.class})
@ConditionalOnClass(value={Flyway.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@Import(value={FlywayAutoMigrate.class})
public class CloudtFlywayAutoConfiguration {
    private static final Logger log = LogManager.getLogger(CloudtFlywayAutoConfiguration.class);
    private final FlywayCloudtProperties properties;

    public CloudtFlywayAutoConfiguration(FlywayCloudtProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public FlywayBuilder flywayBuilder(Environment environment) {
        DataSource dataSource = DatasourceLoadUtil.loadForHikari((Environment)environment);
        Assert.notNull((Object)dataSource, (String)"\u521d\u59cb\u5316flyway\u5931\u8d25\uff0c\u672a\u52a0\u8f7d\u5230\u6709\u6548\u6570\u636e\u6e90", (Object[])new Object[0]);
        return new FlywayBuilder(dataSource, this.properties);
    }

    @Bean
    public FlywayHelper flywayHolder() {
        return new FlywayHelper(this.properties);
    }

    static class FlywayAutoMigrate
    implements ApplicationRunner {
        @Autowired
        private FlywayCloudtProperties flywayCloudtProperties;
        @Autowired
        private FlywayBuilder flywayBuilder;
        @Autowired
        private FlywayHelper flywayHelper;
        @Autowired
        private TaskExecutor taskExecutor;

        FlywayAutoMigrate() {
        }

        public void run(ApplicationArguments args) throws Exception {
            this.taskExecutor.execute(() -> {
                log.info("\u68c0\u67e5\u3010\u7cfb\u7edf\u3011\u6570\u636e\u5e93\u811a\u672c...");
                this.checkSysScript();
                log.info("\u68c0\u67e5\u3010\u7cfb\u7edf\u3011\u6570\u636e\u5e93\u811a\u672c\u7ed3\u675f");
            });
        }

        private void checkSysScript() {
            if (this.flywayCloudtProperties.getAutoMigrateAfterStart().isNegative() || this.flywayCloudtProperties.getAutoMigrateAfterStart().isZero()) {
                log.info("\u68c0\u67e5\u3010\u7cfb\u7edf\u3011\u6570\u636e\u5e93\u811a\u672c\u5ffd\u7565");
                return;
            }
            this.flywayHelper.migrate(this.flywayBuilder::createFlywayForSys);
        }
    }
}

