package com.elitescloud.boot.flyway;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;
import java.util.Set;

/**
 * flyway相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/23
 */
@ConfigurationProperties(prefix = FlywayCloudtProperties.CONFIG_PREFIX)
public class FlywayCloudtProperties {

    public static final String CONFIG_PREFIX = "elitesland.flyway";

    /**
     * 是否启用
     */
    private boolean enabled = false;

    /**
     * 系统的数据库脚本目录
     */
    private Set<String> locationSys = Set.of("classpath:db/migration/sys");

    /**
     * 租户相关的数据库脚本目录
     */
    private Set<String> locationTenant = Set.of("classpath:db/migration/tenants");

    /**
     * 所属项目，如果不设置，则是在对应location根目录下，否则追加上项目标识
     */
    private String project;

    /**
     * 默认schema
     */
    private String schemaDefault;

    /**
     * 是否开启baseline
     */
    private boolean baselineOnMigrate = true;

    /**
     * baseline 版本，小于该版本的会忽略
     */
    private String baselineVersion = "1";

    /**
     * migrate时是否校验
     */
    private boolean validateOnMigrate = false;

    /**
     * 是否校验脚本名称格式
     */
    private boolean validateMigrationNaming = true;

    /**
     * 已存在的脚本不再执行
     */
    private boolean outOfOrder = true;

    /**
     * 系统启动后自动检查升级脚本，默认10秒后
     */
    private Duration autoMigrateAfterStart = Duration.ofSeconds(10);

    /**
     * 升级脚本失败后重试次数，默认3次
     */
    private int retryTimes = 3;

    /**
     * 失败后重试间隔，默认1分钟
     */
    private Duration retryInterval = Duration.ofMinutes(1);

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Set<String> getLocationSys() {
        return locationSys;
    }

    public void setLocationSys(Set<String> locationSys) {
        this.locationSys = locationSys;
    }

    public Set<String> getLocationTenant() {
        return locationTenant;
    }

    public void setLocationTenant(Set<String> locationTenant) {
        this.locationTenant = locationTenant;
    }

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getSchemaDefault() {
        return schemaDefault;
    }

    public void setSchemaDefault(String schemaDefault) {
        this.schemaDefault = schemaDefault;
    }

    public boolean isBaselineOnMigrate() {
        return baselineOnMigrate;
    }

    public void setBaselineOnMigrate(boolean baselineOnMigrate) {
        this.baselineOnMigrate = baselineOnMigrate;
    }

    public String getBaselineVersion() {
        return baselineVersion;
    }

    public void setBaselineVersion(String baselineVersion) {
        this.baselineVersion = baselineVersion;
    }

    public boolean isValidateOnMigrate() {
        return validateOnMigrate;
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public boolean isValidateMigrationNaming() {
        return validateMigrationNaming;
    }

    public void setValidateMigrationNaming(boolean validateMigrationNaming) {
        this.validateMigrationNaming = validateMigrationNaming;
    }

    public boolean isOutOfOrder() {
        return outOfOrder;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    public Duration getAutoMigrateAfterStart() {
        return autoMigrateAfterStart;
    }

    public void setAutoMigrateAfterStart(Duration autoMigrateAfterStart) {
        this.autoMigrateAfterStart = autoMigrateAfterStart;
    }

    public int getRetryTimes() {
        return retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Duration getRetryInterval() {
        return retryInterval;
    }

    public void setRetryInterval(Duration retryInterval) {
        this.retryInterval = retryInterval;
    }
}
