/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.flyway.common;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.flyway.FlywayCloudtProperties;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;

public class FlywayHelper {
    private static final Logger logger = CloudtBootLoggerFactory.DB_VERSION_FLYEAY.getLogger(FlywayHelper.class);
    private final FlywayCloudtProperties properties;

    public FlywayHelper(FlywayCloudtProperties properties) {
        this.properties = properties;
    }

    public void migrate(Supplier<Flyway> flywaySupplier) {
        try {
            flywaySupplier.get().migrate();
            return;
        }
        catch (Exception e) {
            logger.error("\u5347\u7ea7\u811a\u672c\u5f02\u5e38\uff1a", (Throwable)e);
            flywaySupplier.get().repair();
            int times = 1;
            while (times < this.properties.getRetryTimes()) {
                try {
                    TimeUnit.SECONDS.sleep(this.properties.getRetryInterval().getSeconds());
                    logger.info("\u91cd\u8bd5\u5347\u7ea7\u811a\u672c\u7b2c{}\u6b21...", (Object)times);
                    flywaySupplier.get().migrate();
                    logger.info("\u91cd\u8bd5\u5347\u7ea7\u811a\u672c\u7b2c{}\u6b21\u6210\u529f\uff01", (Object)times);
                    return;
                }
                catch (Exception e2) {
                    logger.error("\u5347\u7ea7\u811a\u672c\u5f02\u5e38\uff1a", (Throwable)e2);
                }
            }
            return;
        }
    }
}

