/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config.auditing;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.boot.jpa.CloudtDataProperties;
import com.elitescloud.boot.jpa.common.PartitionField;
import com.elitescloud.boot.jpa.config.auditing.AuditCustomizer;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.boot.util.BeanWrapperUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAuditUtil {
    private static final Logger log = LoggerFactory.getLogger(CustomAuditUtil.class);
    private static TenantClientProvider tenantClientProvider;
    private static UserDetailProvider userProvider;
    private static CloudtDataProperties dataProperties;
    private static List<AuditCustomizer> customizers;

    public static <T> T markCreated(@Nonnull T source) {
        CustomAuditUtil.partitionFieldHandler(source);
        if (source instanceof BaseModel) {
            BaseModel entity = (BaseModel)source;
            LocalDateTime now = entity.getCreateTime() == null ? LocalDateTime.now() : entity.getCreateTime();
            Long tenantId = entity.getTenantId() == null ? CustomAuditUtil.obtainTenantId() : entity.getTenantId();
            Long tenantOrgId = entity.getTenantOrgId() == null ? CustomAuditUtil.obtainTenantOrgId() : entity.getTenantOrgId();
            Long orgId = (Long)ObjectUtil.defaultIfNull((Object)entity.getBelongOrgId(), (Object)entity.getSecBuId());
            GeneralUserDetails user = CustomAuditUtil.currentUser();
            Long currentUserId = 0L;
            String currentUsername = null;
            if (user != null && user.getUser() != null) {
                currentUserId = user.getUserId();
                currentUsername = CustomAuditUtil.obtainCurrentUserName(user);
                Long l = orgId = orgId == null ? user.getOrgId() : orgId;
            }
            if (entity.getCreateUserId() != null && CharSequenceUtil.isNotBlank((CharSequence)entity.getCreator())) {
                currentUserId = entity.getCreateUserId();
                currentUsername = entity.getCreator();
            }
            entity.setCreateUserId(currentUserId);
            entity.setCreator(currentUsername);
            entity.setCreateTime(now);
            if (entity.getModifyUserId() == null || CharSequenceUtil.isBlank((CharSequence)entity.getUpdater())) {
                entity.setModifyUserId(currentUserId);
                entity.setUpdater(currentUsername);
            }
            entity.setModifyTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)entity.getModifyTime(), (Object)now));
            entity.setDeleteFlag((Integer)ObjectUtil.defaultIfNull((Object)entity.getDeleteFlag(), (Object)0));
            entity.setTenantId(tenantId);
            entity.setTenantOrgId(tenantOrgId);
            entity.setBelongOrgId(orgId);
        }
        CustomAuditUtil.getCustomizers().forEach(t -> t.onCreate(source));
        return source;
    }

    private static <T> void partitionFieldHandler(T source) {
        List fields = BeanWrapperUtil.getFieldsByAnnotation(source, PartitionField.class, (boolean)true);
        if (fields.isEmpty()) {
            return;
        }
        LocalDate currentDate = LocalDate.now();
        for (BeanWrapperUtil.CustomField field : fields) {
            PartitionField anno = (PartitionField)field.getAnnotation(PartitionField.class);
            if (anno == null) continue;
            PartitionField.PartitionType partitionType = anno.value();
            Object partitionValue = "";
            switch (partitionType) {
                case YEAR: {
                    partitionValue = "" + currentDate.getYear();
                    break;
                }
                case YEAR_MONTH: {
                    partitionValue = currentDate.format(DateTimeFormatter.ofPattern("yyyyMM"));
                    break;
                }
                case YEAR_MONTH_DAY: {
                    partitionValue = currentDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                }
            }
            try {
                field.getWriteMethod().invoke(source, partitionValue);
            }
            catch (Exception e) {
                log.error("\u5206\u533a\u5b57\u6bb5\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    @Nonnull
    public static <T> T markModified(@Nonnull T source) {
        if (source instanceof BaseModel) {
            BaseModel entity = (BaseModel)source;
            GeneralUserDetails user = CustomAuditUtil.currentUser();
            if (user != null && user.getUser() != null) {
                entity.setModifyUserId(user.getUserId());
                entity.setUpdater(CustomAuditUtil.obtainCurrentUserName(user));
            }
            entity.setModifyTime(LocalDateTime.now());
            entity.setDeleteFlag((Integer)ObjectUtil.defaultIfNull((Object)entity.getDeleteFlag(), (Object)0));
        }
        CustomAuditUtil.getCustomizers().forEach(t -> t.onUpdate(source));
        return source;
    }

    protected static String obtainCurrentUserName(GeneralUserDetails currentUser) {
        if (currentUser == null) {
            currentUser = CustomAuditUtil.currentUser();
        }
        if (currentUser == null) {
            return null;
        }
        CloudtDataProperties.AuditorType auditorType = (CloudtDataProperties.AuditorType)((Object)ObjectUtil.defaultIfNull((Object)((Object)CustomAuditUtil.getDataProperties().getAuditorType()), (Object)((Object)CloudtDataProperties.AuditorType.FULL_NAME)));
        switch (auditorType) {
            case FULL_NAME: {
                return currentUser.getUser().getPrettyName();
            }
            case USER_NAME: {
                return currentUser.getUsername();
            }
            case CUSTOM: {
                log.warn("\u6682\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49");
                return currentUser.getUser().getPrettyName();
            }
        }
        return null;
    }

    protected static Long obtainTenantId() {
        SysTenantDTO currentTenant = CustomAuditUtil.getTenantClientProvider().getSessionTenant();
        if (currentTenant != null) {
            return currentTenant.getId();
        }
        return TenantConstant.DEFAULT_TENANT_ID;
    }

    protected static Long obtainTenantOrgId() {
        Boolean useTenantOrg = TenantOrgContext.isUseTenantOrg();
        if (!((Boolean)ObjectUtil.defaultIfNull((Object)useTenantOrg, (Object)true)).booleanValue()) {
            return null;
        }
        return TenantOrgContext.getTenantOrg();
    }

    protected static GeneralUserDetails currentUser() {
        if (userProvider == null) {
            userProvider = (UserDetailProvider)SpringContextHolder.getBean(UserDetailProvider.class);
        }
        return userProvider.currentUser();
    }

    protected static TenantClientProvider getTenantClientProvider() {
        if (tenantClientProvider == null) {
            tenantClientProvider = (TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class);
        }
        return tenantClientProvider;
    }

    public static CloudtDataProperties getDataProperties() {
        if (dataProperties == null) {
            dataProperties = (CloudtDataProperties)SpringContextHolder.getBean(CloudtDataProperties.class);
        }
        return dataProperties;
    }

    protected static List<AuditCustomizer> getCustomizers() {
        if (customizers == null) {
            customizers = SpringContextHolder.getObjectProvider(AuditCustomizer.class).stream().collect(Collectors.toList());
        }
        return customizers;
    }
}

