/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config;

import cn.hutool.core.util.ObjectUtil;
import com.blazebit.persistence.Criteria;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.spi.CriteriaBuilderConfiguration;
import com.elitescloud.boot.data.config.CloudtDataProperties;
import com.elitescloud.boot.jpa.CloudtJpaProperties;
import com.elitescloud.boot.jpa.support.dialect.CustomMySQL5Dialect;
import com.elitescloud.boot.jpa.support.dialect.CustomPostgreSQL10Dialect;
import com.elitescloud.boot.jpa.util.DatabaseDialectDetector;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.PostgreSQL10Dialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.util.StringUtils;

public class HibernateConfig {
    private static final Logger logger = LoggerFactory.getLogger(HibernateConfig.class);
    private final CloudtJpaProperties cloudtJpaProperties;
    private final JpaProperties jpaProperties;

    public HibernateConfig(CloudtJpaProperties cloudtJpaProperties, JpaProperties jpaProperties) {
        this.cloudtJpaProperties = cloudtJpaProperties;
        this.jpaProperties = jpaProperties;
    }

    @Bean
    public HibernatePropertiesCustomizer hibernatePropertiesCustomizer() {
        return hibernateProperties -> {
            hibernateProperties.putIfAbsent("hibernate.use_sql_comments", false);
            hibernateProperties.putIfAbsent("hibernate.schema_update.unique_constraint_strategy", "RECREATE_QUIETLY");
            hibernateProperties.putIfAbsent("hibernate.jdbc.batch_size", 50);
            hibernateProperties.putIfAbsent("hibernate.order_inserts", "true");
            hibernateProperties.putIfAbsent("hibernate.order_updates", "true");
            hibernateProperties.putIfAbsent("hibernate.jdbc.batch_versioned_data", "true");
            if (this.isMySQLDialect()) {
                hibernateProperties.putIfAbsent("hibernate.dialect", CustomMySQL5Dialect.class.getName());
            } else if (this.ispPostgresqlDialect()) {
                hibernateProperties.putIfAbsent("hibernate.dialect", CustomPostgreSQL10Dialect.class.getName());
            }
        };
    }

    @Bean
    public JPAQueryFactory jpaQueryFactory(EntityManager em, ObjectProvider<UserDetailProvider> userProvider, CloudtDataProperties dataProperties) {
        return new CloudtJPAQueryFactory(em, (UserDetailProvider)userProvider.getIfAvailable(), dataProperties);
    }

    @Bean
    @Scope(value="singleton")
    public CriteriaBuilderFactory criteriaBuilderFactory(EntityManagerFactory entityManagerFactory) {
        CriteriaBuilderConfiguration criteria = Criteria.getDefault();
        criteria.setProperty("com.blazebit.persistence.compatible_mode", this.cloudtJpaProperties.getBlaze().getCompatibleMode().toString());
        criteria.setProperty("com.blazebit.persistence.returning_clause_case_sensitive", this.cloudtJpaProperties.getBlaze().getReturningClauseCaseSensitive().toString());
        criteria.setProperty("com.blazebit.persistence.size_to_count_transformation", this.cloudtJpaProperties.getBlaze().getSizeToCountTransformation().toString());
        criteria.setProperty("com.blazebit.persistence.implicit_group_by_from_select", this.cloudtJpaProperties.getBlaze().getImplicitGroupByFromSelect().toString());
        criteria.setProperty("com.blazebit.persistence.implicit_group_by_from_having", this.cloudtJpaProperties.getBlaze().getImplicitGroupByFromHaving().toString());
        criteria.setProperty("com.blazebit.persistence.implicit_group_by_from_order_by", this.cloudtJpaProperties.getBlaze().getImplicitGroupByFromOrderBy().toString());
        criteria.setProperty("com.blazebit.persistence.expression_optimization", this.cloudtJpaProperties.getBlaze().getExpressionOptimization().toString());
        criteria.setProperty("com.blazebit.persistence.expression.cache_class", this.cloudtJpaProperties.getBlaze().getCacheClass());
        criteria.setProperty("com.blazebit.persistence.values.filter_nulls", this.cloudtJpaProperties.getBlaze().getFilterNulls().toString());
        criteria.setProperty("com.blazebit.persistence.parameter_literal_rendering", this.cloudtJpaProperties.getBlaze().getParameterLiteralRendering().toString());
        criteria.setProperty("com.blazebit.persistence.optimized_keyset_predicate_rendering", this.cloudtJpaProperties.getBlaze().getOptimizedKeysetPredicateRendering().toString());
        criteria.setProperty("com.blazebit.persistence.inline_id_query", this.cloudtJpaProperties.getBlaze().getInlineIdQuery());
        criteria.setProperty("com.blazebit.persistence.inline_count_query", this.cloudtJpaProperties.getBlaze().getInlineCountQuery());
        criteria.setProperty("com.blazebit.persistence.inline_ctes", this.cloudtJpaProperties.getBlaze().getInlineCtes());
        criteria.setProperty("com.blazebit.persistence.query_plan_cache_enabled", this.cloudtJpaProperties.getBlaze().getQueryPlanCacheEnabled().toString());
        criteria.setProperty("com.blazebit.persistence.criteria_negation_wrapper", this.cloudtJpaProperties.getBlaze().getCriteriaNegationWrapper().toString());
        criteria.setProperty("com.blazebit.persistence.criteria_value_as_parameter", this.cloudtJpaProperties.getBlaze().getCriteriaValueAsParameter().toString());
        return criteria.createCriteriaBuilderFactory(entityManagerFactory);
    }

    private boolean ispPostgresqlDialect() {
        String dialectStr = this.jpaProperties.getDatabasePlatform();
        if (!StringUtils.hasText((String)dialectStr)) {
            return true;
        }
        try {
            return PostgreSQL81Dialect.class.isAssignableFrom(Class.forName(dialectStr));
        }
        catch (ClassNotFoundException e) {
            logger.error("\u81ea\u5b9a\u4e49\u5b57\u6bb5\u65b9\u8a00\u4e0d\u5339\u914d,\u51fd\u6570\u65e0\u6cd5\u6ce8\u518c\uff1a {} \u9700\u8981\uff1a{}", (Object)dialectStr, (Object)PostgreSQL10Dialect.class.getName());
            return false;
        }
    }

    private boolean isMySQLDialect() {
        String dialectStr = this.jpaProperties.getDatabasePlatform();
        if (!StringUtils.hasText((String)dialectStr)) {
            return true;
        }
        try {
            return MySQLDialect.class.isAssignableFrom(Class.forName(dialectStr));
        }
        catch (ClassNotFoundException e) {
            logger.error("\u81ea\u5b9a\u4e49\u5b57\u6bb5\u65b9\u8a00\u4e0d\u5339\u914d,\u51fd\u6570\u65e0\u6cd5\u6ce8\u518c\uff1a {} \u9700\u8981\uff1a{}", (Object)dialectStr, (Object)MySQLDialect.class.getName());
            return false;
        }
    }

    @Bean
    public DatabaseDialectDetector getDatabaseDialectDetector() {
        return new DatabaseDialectDetector(this.jpaProperties);
    }

    static class CloudtJPAQueryFactory
    extends JPAQueryFactory {
        private static final Logger log = LoggerFactory.getLogger(CloudtJPAQueryFactory.class);
        private final UserDetailProvider userProvider;
        private final CloudtDataProperties dataProperties;

        public CloudtJPAQueryFactory(EntityManager entityManager, UserDetailProvider userProvider, CloudtDataProperties dataProperties) {
            super(entityManager);
            this.userProvider = userProvider;
            this.dataProperties = dataProperties;
        }

        public JPAUpdateClause update(EntityPath<?> path) {
            JPAUpdateClause clause = super.update(path);
            this.auditForUpdate(path, clause);
            return clause;
        }

        private void auditForUpdate(EntityPath<?> path, JPAUpdateClause clause) {
            if (BaseModel.class.isAssignableFrom(path.getType())) {
                GeneralUserDetails user;
                LocalDateTime now = LocalDateTime.now();
                clause.set((Path)Expressions.dateTimePath(LocalDateTime.class, path, (String)"modifyTime"), (Object)now);
                GeneralUserDetails generalUserDetails = user = this.userProvider == null ? null : this.userProvider.currentUser();
                if (user != null) {
                    clause.set((Path)Expressions.numberPath(Long.class, path, (String)"modifyUserId"), (Object)user.getUserId());
                    clause.set((Path)Expressions.stringPath(path, (String)"updater"), (Object)this.obtainCurrentUserName(user));
                }
            }
        }

        private String obtainCurrentUserName(GeneralUserDetails currentUser) {
            if (currentUser == null) {
                return null;
            }
            CloudtDataProperties.AuditorType auditorType = (CloudtDataProperties.AuditorType)ObjectUtil.defaultIfNull((Object)this.dataProperties.getAuditorType(), (Object)CloudtDataProperties.AuditorType.FULL_NAME);
            switch (auditorType) {
                case FULL_NAME: {
                    return currentUser.getUser().getPrettyName();
                }
                case USER_NAME: {
                    return currentUser.getUsername();
                }
                case CUSTOM: {
                    log.warn("\u6682\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49");
                    return currentUser.getUser().getPrettyName();
                }
            }
            return null;
        }
    }
}

