/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.util;

import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.PostgreSQL10Dialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.hibernate.dialect.PostgreSQL94Dialect;
import org.hibernate.dialect.PostgreSQL9Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.util.StringUtils;

public class DatabaseDialectDetector {
    private static final Logger log = LoggerFactory.getLogger(DatabaseDialectDetector.class);
    private final JpaProperties jpaProperties;

    public DatabaseDialectDetector(JpaProperties jpaProperties) {
        this.jpaProperties = jpaProperties;
    }

    public boolean ispPostgresqlDialect() {
        String dialectStr = this.jpaProperties.getDatabasePlatform();
        if (!StringUtils.hasText((String)dialectStr)) {
            return true;
        }
        try {
            if (PostgreSQL10Dialect.class.isAssignableFrom(Class.forName(dialectStr))) {
                return true;
            }
            if (PostgreSQL81Dialect.class.isAssignableFrom(Class.forName(dialectStr))) {
                return true;
            }
            if (PostgreSQLDialect.class.isAssignableFrom(Class.forName(dialectStr))) {
                return true;
            }
            if (PostgreSQL82Dialect.class.isAssignableFrom(Class.forName(dialectStr))) {
                return true;
            }
            if (PostgreSQL94Dialect.class.isAssignableFrom(Class.forName(dialectStr))) {
                return true;
            }
            return PostgreSQL9Dialect.class.isAssignableFrom(Class.forName(dialectStr));
        }
        catch (ClassNotFoundException e) {
            log.error("\u81ea\u5b9a\u4e49\u5b57\u6bb5\u65b9\u8a00\u4e0d\u5339\u914d,\u51fd\u6570\u65e0\u6cd5\u6ce8\u518c\uff1a {} \u9700\u8981\uff1a{}", (Object)dialectStr, (Object)PostgreSQL10Dialect.class.getName());
            return false;
        }
    }

    public boolean isMySQLDialect() {
        String dialectStr = this.jpaProperties.getDatabasePlatform();
        if (!StringUtils.hasText((String)dialectStr)) {
            return true;
        }
        try {
            return MySQLDialect.class.isAssignableFrom(Class.forName(dialectStr));
        }
        catch (ClassNotFoundException e) {
            log.error("\u81ea\u5b9a\u4e49\u5b57\u6bb5\u65b9\u8a00\u4e0d\u5339\u914d,\u51fd\u6570\u65e0\u6cd5\u6ce8\u518c\uff1a {} \u9700\u8981\uff1a{}", (Object)dialectStr, (Object)MySQLDialect.class.getName());
            return false;
        }
    }
}

