/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.querydsl.BlazeJPAQuery;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.TemporalExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.internal.SessionImpl;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class BaseRepoProc<T extends Serializable> {
    private static final Logger logger = CloudtBootLoggerFactory.REPO_JPA.getLogger(BaseRepoProc.class);
    protected JPAQueryFactory jpaQueryFactory;
    protected EntityManager entityManager;
    protected CriteriaBuilderFactory criteriaBuilderFactory;
    private final EntityPathBase<T> qModel;
    private PathBuilder<?> pathBuilder;

    protected BaseRepoProc(@NotNull EntityPathBase<T> qModel) {
        this.qModel = qModel;
    }

    public long generateId() {
        return IdFactory.generateLong();
    }

    @Transactional(rollbackFor={Exception.class})
    public T save(@NotNull T data) {
        if (this.getId(data) == null) {
            this.entityManager.persist(data);
            return data;
        }
        return (T)((Serializable)this.entityManager.merge(data));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<T> save(@NotEmpty Collection<T> dataList) {
        ArrayList<Serializable> recordList = new ArrayList<Serializable>(dataList.size());
        int batchSize = this.obtainBatchSize();
        int index = 0;
        for (Serializable data : dataList) {
            recordList.add(this.save(data));
            if (batchSize <= 1 || ++index % batchSize != 0) continue;
            logger.info("save batch:{}/{}", (Object)index, (Object)batchSize);
            this.entityManager.flush();
            this.entityManager.clear();
        }
        this.entityManager.flush();
        this.entityManager.clear();
        return recordList;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<T> saveStatelessSession(@NotEmpty Collection<T> dataList) {
        StatelessSession session = ((Session)this.entityManager.unwrap(Session.class)).getSessionFactory().openStatelessSession();
        session.setJdbcBatchSize(Integer.valueOf(1000));
        Transaction tx = session.beginTransaction();
        try {
            boolean i = false;
            for (Serializable t : dataList) {
                if (this.getId(t) == null) {
                    session.insert((Object)t);
                    this.setId(t, this.getId(t));
                    continue;
                }
                session.update((Object)t);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            session.close();
        }
        return new ArrayList<T>(dataList);
    }

    @Transactional(rollbackFor={Exception.class})
    public long delete() {
        return this.jpaQueryFactory.delete(this.qModel).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public long delete(long id) {
        return this.delete((Predicate)this.getIdPath().eq((Object)id));
    }

    @Transactional(rollbackFor={Exception.class})
    public long delete(@NotEmpty Collection<Long> ids) {
        return this.delete((Predicate)this.getIdPath().in(ids));
    }

    protected long delete(Predicate predicate) {
        return this.jpaQueryFactory.delete(this.qModel).where(new Predicate[]{predicate}).execute();
    }

    protected <P, Q extends Path<P>> long deleteByValue(@NotNull Q path, P value) {
        return this.delete((Predicate)this.fieldEq(path, value));
    }

    protected <P, Q extends Path<P>> long deleteByValue(@NotNull Q path, @NotEmpty Collection<P> values) {
        return this.delete((Predicate)this.fieldIn(path, values));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateDeleteFlag() {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)1).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateDeleteFlag(long id) {
        return this.updateDeleteFlag((Predicate)this.getIdPath().eq((Object)id));
    }

    protected long updateDeleteFlag(Predicate predicate) {
        return this.updateDeleteFlag(predicate, 1);
    }

    protected long updateDeleteFlag(Predicate predicate, int value) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)value).where(new Predicate[]{predicate}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateDeleteFlag(long id, int value) {
        return this.updateDeleteFlag((Predicate)this.getIdPath().eq((Object)id), value);
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateDeleteFlag(@NotEmpty Collection<Long> ids) {
        return this.updateDeleteFlag((Predicate)this.getIdPath().in(ids));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateDeleteFlag(@NotEmpty Collection<Long> ids, int value) {
        return this.updateDeleteFlag((Predicate)this.getIdPath().in(ids), value);
    }

    protected long updateDeleteFlagByValue(Predicate predicate) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)1).where(new Predicate[]{predicate}).execute();
    }

    protected <P, Q extends Path<P>> long updateDeleteFlagByValue(@NotNull Q path, P value) {
        return this.updateDeleteFlagByValue((Predicate)this.fieldEq(path, value));
    }

    protected <P, Q extends Path<P>> long updateDeleteFlagByValue(@NotNull Q path, @NotEmpty Collection<P> values) {
        return this.updateDeleteFlagByValue((Predicate)this.fieldIn(path, values));
    }

    @Transactional(rollbackFor={Exception.class})
    public long removeDeleteFlag() {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)0).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public long removeDeleteFlag(long id) {
        return this.removeDeleteFlag((Predicate)this.getIdPath().eq((Object)id));
    }

    @Transactional(rollbackFor={Exception.class})
    public long removeDeleteFlag(@NotEmpty Collection<Long> ids) {
        return this.removeDeleteFlag((Predicate)this.getIdPath().in(ids));
    }

    protected long removeDeleteFlag(Predicate predicate) {
        return this.updateDeleteFlag(predicate, 0);
    }

    protected <P, Q extends Path<P>> long removeDeleteFlagByValue(@NotNull Q path, P value) {
        return this.removeDeleteFlag((Predicate)this.fieldEq(path, value));
    }

    protected <P, Q extends Path<P>> long removeDeleteFlagByValue(@NotNull Q path, @NotEmpty Collection<P> values) {
        return this.removeDeleteFlag((Predicate)this.fieldIn(path, values));
    }

    public T get(long id) {
        return (T)((Serializable)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where((Predicate)this.getIdPath().eq((Object)id))).limit(1L)).fetchOne());
    }

    public <E> E get(@NotNull QBean<E> qBean, long id) {
        return (E)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(qBean).from(this.qModel)).where((Predicate)this.getIdPath().eq((Object)id))).limit(1L)).fetchOne();
    }

    public Optional<T> getOptional(long id) {
        return Optional.ofNullable(this.get(id));
    }

    public <E> Optional<E> getOptional(@NotNull QBean<E> qBean, long id) {
        return Optional.ofNullable(this.get(qBean, id));
    }

    public List<T> get(@NotEmpty Collection<Long> ids) {
        return this.getList((Predicate)this.getIdPath().in(ids), new OrderSpecifier[0]);
    }

    public <E> List<E> get(@NotNull QBean<E> qBean, @NotEmpty Collection<Long> ids) {
        return this.getList(qBean, (Predicate)this.getIdPath().in(ids), new OrderSpecifier[0]);
    }

    public List<T> get(@NotEmpty Long[] ids) {
        return this.getList((Predicate)this.getIdPath().in((Object[])ids), new OrderSpecifier[0]);
    }

    public <E> List<E> get(@NotNull QBean<E> qBean, @NotEmpty Long[] ids) {
        return this.getList(qBean, (Predicate)this.getIdPath().in((Object[])ids), new OrderSpecifier[0]);
    }

    protected <P, Q extends Path<P>> T getOneByValue(@NotNull Q path, P value) {
        return (T)((Serializable)this.getOneOptionalByValue(path, value).orElse(null));
    }

    protected <E, P, Q extends Path<P>> E getOneByValue(@NotNull QBean<E> qBean, @NotNull Q path, P value) {
        return this.getOneOptionalByValue(qBean, path, value).orElse(null);
    }

    protected T getOne(Predicate predicate) {
        return (T)((Serializable)this.getOneOptional(predicate).orElse(null));
    }

    protected <E> E getOne(@NotNull QBean<E> qBean, Predicate predicate) {
        return this.getOneOptional(qBean, predicate).orElse(null);
    }

    protected <P, Q extends Path<P>> Optional<T> getOneOptionalByValue(@NotNull Q path, P value) {
        return this.getOneOptional((Predicate)this.fieldEq(path, value));
    }

    protected <E, P, Q extends Path<P>> Optional<E> getOneOptionalByValue(@NotNull QBean<E> qBean, @NotNull Q path, P value) {
        return this.getOneOptional(qBean, (Predicate)this.fieldEq(path, value));
    }

    protected Optional<T> getOneOptional(Predicate predicate) {
        return Optional.ofNullable((Serializable)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where(predicate)).limit(1L)).fetchOne());
    }

    protected <E> Optional<E> getOneOptional(@NotNull QBean<E> qBean, Predicate predicate) {
        return Optional.ofNullable(((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(qBean).from(this.qModel)).where(predicate)).limit(1L)).fetchOne());
    }

    protected List<T> getList(Predicate predicate, OrderSpecifier<?> ... orders) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectFrom(this.qModel).where(predicate)).orderBy(orders)).fetch();
    }

    protected <E> List<E> getList(QBean<E> targetBean, Predicate predicate, OrderSpecifier<?> ... orders) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(targetBean).from(this.qModel)).where(predicate)).orderBy(orders)).fetch();
    }

    protected <P, Q extends Path<P>> List<T> getListByValue(@NotNull Q path, P value, OrderSpecifier<?> ... orders) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectFrom(this.qModel).where((Predicate)this.fieldEq(path, value))).orderBy(orders)).fetch();
    }

    protected <P, Q extends Path<P>> List<T> getListByValue(@NotNull Q path, @NotEmpty Collection<P> value, OrderSpecifier<?> ... orders) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectFrom(this.qModel).where((Predicate)this.fieldIn(path, value))).orderBy(orders)).fetch();
    }

    protected <E, P, Q extends Path<P>> List<E> getListByValue(QBean<E> targetBean, @NotNull Q path, P value, OrderSpecifier<?> ... orders) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(targetBean).from(this.qModel)).where((Predicate)this.fieldEq(path, value))).orderBy(orders)).fetch();
    }

    protected <E, P, Q extends Path<P>> List<E> getListByValue(QBean<E> targetBean, @NotNull Q path, @NotEmpty Collection<P> value, OrderSpecifier<?> ... orders) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(targetBean).from(this.qModel)).where((Predicate)this.fieldIn(path, value))).orderBy(orders)).fetch();
    }

    protected <E extends Serializable, U extends Serializable> Map<E, List<U>> getListForGroup(@NotEmpty Expression<?>[] pathes, Predicate predicate, @NotNull Function<Tuple, E> keyMapper, @NotNull Function<Tuple, U> dataMapper) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(pathes).from(this.qModel)).where(predicate)).fetch().stream().collect(Collectors.groupingBy(keyMapper, Collectors.mapping(dataMapper, Collectors.toList())));
    }

    protected <E extends Serializable, U extends Serializable> Map<E, List<U>> getListForGroup(@NotNull JPAQuery<Tuple> jpaQuery, @NotNull Function<Tuple, E> keyMapper, @NotNull Function<Tuple, U> dataMapper) {
        return jpaQuery.fetch().stream().collect(Collectors.groupingBy(keyMapper, Collectors.mapping(dataMapper, Collectors.toList())));
    }

    public boolean exists(long id) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where((Predicate)this.getIdPath().eq((Object)id))).limit(1L)).fetchOne() != null;
    }

    public List<Long> exists(Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where((Predicate)this.getIdPath().in(ids))).fetch();
    }

    public List<T> all() {
        return this.getList(null, new OrderSpecifier[0]);
    }

    public <E> List<E> all(QBean<E> targetBean) {
        return this.getList(targetBean, null, new OrderSpecifier[0]);
    }

    public List<T> allForUnDeleted() {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where((Predicate)this.getDeleteFlagPath().eq((Object)0))).fetch();
    }

    public List<Long> allId() {
        return ((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).fetch();
    }

    public List<Long> allIdForUnDeleted() {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where((Predicate)this.getDeleteFlagPath().eq((Object)0))).fetch();
    }

    protected <P, Q extends Path<P>> P getValue(@NotNull Q path) {
        return this.getValue(path, null, new OrderSpecifier[0]);
    }

    protected <P, Q extends Path<P>> P getValue(@NotNull Q path, long id) {
        return this.getValue(path, (Predicate)this.getIdPath().eq((Object)id), new OrderSpecifier[0]);
    }

    protected <P, Q extends Path<P>> P getValue(@NotNull Q path, Predicate predicate, OrderSpecifier<?> ... orders) {
        return this.getValueOptional(path, predicate, orders).orElse(null);
    }

    protected <P, Q extends Path<P>> Optional<P> getValueOptional(@NotNull Q path, long id) {
        return this.getValueOptional(path, (Predicate)this.getIdPath().eq((Object)id), new OrderSpecifier[0]);
    }

    protected <P, Q extends Path<P>> Optional<P> getValueOptional(@NotNull Q path, Predicate predicate, OrderSpecifier<?> ... orders) {
        return Optional.ofNullable(((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(path).from(this.qModel)).where(predicate)).orderBy(orders)).limit(1L)).fetchOne());
    }

    protected <P, Q extends Path<P>> List<P> getValueList(@NotNull Q path, @NotEmpty Collection<Long> ids, OrderSpecifier<?> ... orders) {
        return this.getValueList(path, (Predicate)this.getIdPath().in(ids), orders);
    }

    protected <P, Q extends Path<P>> List<P> getValueList(@NotNull Q path, OrderSpecifier<?> ... orders) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(path).from(this.qModel)).orderBy(orders)).fetch();
    }

    protected <P, Q extends Path<P>> Map<Long, List<P>> getValueListMap(@NotNull Q path, @NotEmpty Collection<Long> ids, OrderSpecifier<?> ... orders) {
        NumberPath<Long> idPath = this.getIdPath();
        List dataList = ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{idPath, path}).from(this.qModel)).where((Predicate)idPath.in(ids))).orderBy(orders)).fetch();
        if (dataList.isEmpty()) {
            return Collections.emptyMap();
        }
        return dataList.stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)idPath), Collectors.mapping(t -> t.get((Expression)path), Collectors.toList())));
    }

    protected <P, Q extends Path<P>, X, Y extends Path<X>> P getValueByValue(@NotNull Q path, @NotNull Y fieldPath, X fieldValue) {
        return this.getValue(path, (Predicate)this.fieldEq(fieldPath, fieldValue), new OrderSpecifier[0]);
    }

    protected <P, Q extends Path<P>, X, Y extends Path<X>> List<P> getValueListByValue(@NotNull Q path, @NotNull Y fieldPath, X fieldValue, OrderSpecifier<?> ... orders) {
        return this.getValueList(path, (Predicate)this.fieldEq(fieldPath, fieldValue), orders);
    }

    protected <P, Q extends Path<P>, X, Y extends Path<X>> List<P> getValueListByValue(@NotNull Q path, @NotNull Y fieldPath, @NotEmpty Collection<X> fieldValues, OrderSpecifier<?> ... orders) {
        return this.getValueList(path, (Predicate)this.fieldIn(fieldPath, fieldValues), orders);
    }

    protected <P, Q extends Path<P>> List<P> getValueList(@NotNull Q path, Predicate predicate, OrderSpecifier<?> ... orders) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(path).from(this.qModel)).where(predicate)).orderBy(orders)).fetch();
    }

    protected Long getIdByPredicate(Predicate predicate, OrderSpecifier<?> ... orders) {
        return (Long)this.getValue((Path)this.getIdPath(), predicate, orders);
    }

    protected <P, Q extends Path<P>> Long getIdByValue(@NotNull Q path, P value) {
        return this.getIdByPredicate((Predicate)this.fieldEq(path, value), new OrderSpecifier[0]);
    }

    protected <P, Q extends Path<P>> Optional<Long> getIdOptionalByValue(@NotNull Q path, P value) {
        return this.getValueOptional((Q)this.getIdPath(), (Predicate)this.fieldEq(path, value), (OrderSpecifier<?>[])new OrderSpecifier[0]);
    }

    protected <P, Q extends Path<P>> List<Long> getIdsByValue(@NotNull Q path, P value, OrderSpecifier<?> ... orders) {
        return this.getIds((Predicate)this.fieldEq(path, value), orders);
    }

    protected <P, Q extends Path<P>> List<Long> getIdsByValue(@NotNull Q path, @NotEmpty Collection<P> value, OrderSpecifier<?> ... orders) {
        return this.getIds((Predicate)this.fieldIn(path, value), orders);
    }

    protected <P, Q extends Path<P>> List<Long> getIds(Predicate predicate, OrderSpecifier<?> ... orders) {
        return this.getValueList((Q)this.getIdPath(), predicate, orders);
    }

    protected <P, Q extends Path<P>> long updateValue(@NotNull Q path, P value, Predicate predicate) {
        return this.jpaQueryFactory.update(this.qModel).set(path, value).where(new Predicate[]{predicate}).execute();
    }

    protected <P, Q extends Path<P>> long updateValue(@NotNull Q path, P value, long id) {
        return this.updateValue(path, value, (Predicate)this.getIdPath().eq((Object)id));
    }

    protected <P, Q extends Path<P>, X, Y extends Path<X>> long updateValueByValue(@NotNull Q path, P value, @NotNull Y fieldPath, X fieldValue) {
        return this.updateValue(path, value, (Predicate)this.fieldEq(fieldPath, fieldValue));
    }

    protected <P, Q extends Path<P>, X, Y extends Path<X>> long updateValueByValue(@NotNull Q path, P value, @NotNull Y fieldPath, @NotEmpty Collection<X> fieldValue) {
        return this.updateValue(path, value, (Predicate)this.fieldIn(fieldPath, fieldValue));
    }

    protected <Q, P extends Path<Q>> boolean exists(@NotNull P path, @NotNull Q value) {
        return this.exists(path, value, null);
    }

    protected <Q, P extends Path<Q>> boolean exists(@NotNull P path, @NotNull Q value, boolean includeDeleted) {
        return this.exists(path, value, null, includeDeleted);
    }

    protected <Q, P extends Path<Q>> boolean exists(@NotNull P path, @NotNull Q value, Long excludeId) {
        return this.exists(path, value, excludeId, true);
    }

    protected <Q, P extends Path<Q>> boolean exists(@NotNull P path, @NotNull Q value, Long excludeId, boolean includeDeleted) {
        BooleanExpression condition = this.fieldEq(path, value);
        if (excludeId != null) {
            condition = condition.and((Predicate)this.getIdPath().ne((Object)excludeId));
        }
        if (!includeDeleted) {
            logger.warn("\u6682\u4e0d\u652f\u6301\u6392\u9664\u6389\u5df2\u5220\u9664\u7684");
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Expressions.numberPath(Integer.class, (String)"1")).from(this.qModel)).where((Predicate)condition)).limit(1L)).fetchOne() != null;
    }

    protected <P, Q extends SimpleExpression<P>> List<P> exists(@NotNull Q path, @NotEmpty Collection<P> value) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(path).from(this.qModel)).where((Predicate)path.in(value))).fetch();
    }

    protected boolean exists(Predicate condition) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Expressions.numberPath(Integer.class, (String)"1")).from(this.qModel)).where(condition)).limit(1L)).fetchOne() != null;
    }

    protected long count(Predicate condition) {
        return (Long)ObjectUtil.defaultIfNull((Object)((Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qModel.count()).from(this.qModel)).where(condition)).fetchOne()), (Object)0L);
    }

    protected <Q, P extends Path<Q>> long count(@NotNull P path, @NotNull Q value) {
        return (Long)ObjectUtil.defaultIfNull((Object)((Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qModel.count()).from(this.qModel)).where((Predicate)this.fieldEq(path, value))).fetchOne()), (Object)0L);
    }

    protected <Q, P extends Path<Q>> long count(@NotNull P path, @NotEmpty Collection<Q> value) {
        return (Long)ObjectUtil.defaultIfNull((Object)((Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qModel.count()).from(this.qModel)).where((Predicate)this.fieldIn(path, value))).fetchOne()), (Object)0L);
    }

    protected long count(@NotNull JPAQuery<T> jpaQuery) {
        return new BlazeJPAQuery(this.entityManager, jpaQuery.getMetadata(), this.criteriaBuilderFactory).fetchCount();
    }

    protected PagingVO<T> queryByPageWrap(@NotNull JPAQuery<T> jpaQuery, @NotNull PageRequest pageRequest) {
        long count = jpaQuery.fetchCount();
        if (count == 0L) {
            return PagingVO.empty();
        }
        Sort sort = pageRequest.getSort();
        if (!sort.isUnsorted()) {
            OrderSpecifier[] orders = (OrderSpecifier[])sort.stream().map(o -> new OrderSpecifier(o.isAscending() ? Order.ASC : Order.DESC, this.convertFieldExpression(o.getProperty()))).toArray(OrderSpecifier[]::new);
            jpaQuery.orderBy(orders);
        }
        ((JPAQuery)jpaQuery.offset(pageRequest.getOffset())).limit((long)pageRequest.getPageSize());
        return PagingVO.builder().total(count).records(jpaQuery.fetch()).build();
    }

    protected <U extends Serializable> PagingVO<U> queryByPage(@NotNull JPAQuery<U> jpaQuery, @NotNull PageRequest pageRequest) {
        return this.queryByPage(jpaQuery, pageRequest, null);
    }

    protected <U extends Serializable> PagingVO<U> queryByPage(@NotNull JPAQuery<U> jpaQuery, @NotNull PageRequest pageRequest, OrderSpecifier<?> defaultOrder) {
        BlazeJPAQuery blazeJpaQuery = new BlazeJPAQuery(this.entityManager, jpaQuery.getMetadata(), this.criteriaBuilderFactory);
        QueryMetadata metadata = blazeJpaQuery.getMetadata();
        boolean supportIdOrder = CollectionUtil.isEmpty((Collection)metadata.getGroupBy());
        if (this.canUseCountWrapper(metadata, true)) {
            PagedList pagedList = ((BlazeJPAQuery)new BlazeJPAQuery(this.entityManager, jpaQuery.getMetadata(), this.criteriaBuilderFactory).orderBy(this.obtainOrders(pageRequest, defaultOrder, supportIdOrder))).fetchPage((int)pageRequest.getOffset(), pageRequest.getPageSize());
            return PagingVO.builder().total(pagedList.getTotalSize()).records((List)pagedList).build();
        }
        long count = blazeJpaQuery.fetchCount();
        if (count == 0L) {
            return PagingVO.builder().build();
        }
        List recordList = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.orderBy(this.obtainOrders(pageRequest, defaultOrder, supportIdOrder))).offset(pageRequest.getOffset())).limit((long)pageRequest.getPageSize())).fetch();
        return PagingVO.builder().total(count).records(recordList).build();
    }

    protected <U extends Serializable> PagingVO<U> queryByPage(@NotNull JPAQuery<Tuple> jpaQuery, @NotNull PageRequest pageRequest, OrderSpecifier<?> defaultOrder, @NotNull Function<Tuple, U> dataMapper) {
        BlazeJPAQuery blazeJpaQuery = new BlazeJPAQuery(this.entityManager, jpaQuery.getMetadata(), this.criteriaBuilderFactory);
        QueryMetadata metadata = blazeJpaQuery.getMetadata();
        if (this.canUseCountWrapper(metadata, true)) {
            PagedList pagedList = ((BlazeJPAQuery)new BlazeJPAQuery(this.entityManager, jpaQuery.getMetadata(), this.criteriaBuilderFactory).orderBy(this.obtainOrders(pageRequest, defaultOrder))).fetchPage((int)pageRequest.getOffset(), pageRequest.getPageSize());
            return PagingVO.builder().total(pagedList.getTotalSize()).records(pagedList.stream().map(dataMapper).collect(Collectors.toList())).build();
        }
        long count = blazeJpaQuery.fetchCount();
        if (count == 0L) {
            return PagingVO.builder().build();
        }
        List recordList = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.orderBy(this.obtainOrders(pageRequest, defaultOrder))).offset(pageRequest.getOffset())).limit((long)pageRequest.getPageSize())).fetch().stream().map(dataMapper).collect(Collectors.toList());
        return PagingVO.builder().total(count).records(recordList).build();
    }

    protected PagingVO<T> queryByPage(Predicate condition, @NotNull PageRequest pageRequest) {
        return this.queryByPage(condition, pageRequest, null);
    }

    protected PagingVO<T> queryByPage(Predicate condition, @NotNull PageRequest pageRequest, OrderSpecifier<?> defaultOrder) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectFrom(this.qModel).where(condition);
        return this.queryByPage(jpaQuery, pageRequest, defaultOrder);
    }

    protected <E extends Serializable> PagingVO<E> queryByPage(QBean<E> targetBean, Predicate condition, @NotNull PageRequest pageRequest) {
        return this.queryByPage(targetBean, condition, pageRequest, null);
    }

    protected <E extends Serializable> PagingVO<E> queryByPage(QBean<E> targetBean, Predicate condition, @NotNull PageRequest pageRequest, OrderSpecifier<?> defaultOrder) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(targetBean).from(this.qModel)).where(condition);
        return this.queryByPage(jpaQuery, pageRequest, defaultOrder);
    }

    protected OrderSpecifier<?>[] obtainOrders(@NotNull PageRequest pageRequest) {
        return this.obtainOrders(pageRequest, null, true);
    }

    protected OrderSpecifier<?>[] obtainOrders(@NotNull PageRequest pageRequest, OrderSpecifier<?> defaultOrder) {
        return this.obtainOrders(pageRequest, defaultOrder, true);
    }

    protected OrderSpecifier<?>[] obtainOrders(@NotNull PageRequest pageRequest, OrderSpecifier<?> defaultOrder, boolean appendId) {
        Sort sort = pageRequest.getSort();
        defaultOrder = this.normalizeDefaultOrder(defaultOrder);
        if (sort.isUnsorted()) {
            OrderSpecifier[] orderSpecifierArray;
            if (appendId) {
                OrderSpecifier[] orderSpecifierArray2;
                if (defaultOrder == null) {
                    OrderSpecifier[] orderSpecifierArray3 = new OrderSpecifier[1];
                    orderSpecifierArray2 = orderSpecifierArray3;
                    orderSpecifierArray3[0] = new OrderSpecifier(Order.DESC, this.getIdPath());
                } else {
                    OrderSpecifier[] orderSpecifierArray4 = new OrderSpecifier[2];
                    orderSpecifierArray4[0] = defaultOrder;
                    orderSpecifierArray2 = orderSpecifierArray4;
                    orderSpecifierArray4[1] = new OrderSpecifier(Order.DESC, this.getIdPath());
                }
                return orderSpecifierArray2;
            }
            if (defaultOrder == null) {
                orderSpecifierArray = new OrderSpecifier[]{};
            } else {
                OrderSpecifier[] orderSpecifierArray5 = new OrderSpecifier[1];
                orderSpecifierArray = orderSpecifierArray5;
                orderSpecifierArray5[0] = defaultOrder;
            }
            return orderSpecifierArray;
        }
        if (appendId) {
            sort = sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        }
        return (OrderSpecifier[])sort.stream().map(o -> new OrderSpecifier(o.isAscending() ? Order.ASC : Order.DESC, this.convertFieldExpression(o.getProperty()))).toArray(OrderSpecifier[]::new);
    }

    protected PageRequest ofPage(Integer page, Integer pageSize) {
        return this.ofPage(page, pageSize, Sort.unsorted());
    }

    protected PageRequest ofPage(Integer page, Integer pageSize, Sort sort) {
        if (page == null || page < 0) {
            page = 0;
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 10;
        }
        if (sort == null) {
            sort = Sort.unsorted();
        }
        return PageRequest.of((int)page, (int)pageSize, (Sort)sort);
    }

    protected PageRequest ofPage(Integer page, Integer pageSize, OrderSpecifier<?>[] orderSpecifiers) {
        if (page == null || page < 0) {
            page = 0;
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 10;
        }
        Sort sort = null;
        if (ArrayUtil.isEmpty((Object[])orderSpecifiers)) {
            sort = Sort.unsorted();
        } else {
            List orders = Arrays.stream(orderSpecifiers).map(t -> t.getOrder() == Order.DESC ? Sort.Order.desc((String)t.getTarget().toString()) : Sort.Order.asc((String)t.getTarget().toString())).collect(Collectors.toList());
            sort = Sort.by(orders);
        }
        return PageRequest.of((int)page, (int)pageSize, (Sort)sort);
    }

    protected Predicate andPredicate(Predicate oldPredicate, Predicate newPredicate) {
        if (newPredicate == null) {
            return oldPredicate;
        }
        return ExpressionUtils.allOf((Predicate[])new Predicate[]{oldPredicate, newPredicate});
    }

    protected <P, Q> Map<P, Q> queryMap(@NotNull Path<P> keyPath, @NotNull Path<Q> valuePath, Predicate ... predicate) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{keyPath, valuePath}).from(this.qModel)).where(predicate)).fetch().stream().filter(t -> t.get((Expression)keyPath) != null && t.get((Expression)valuePath) != null).collect(Collectors.toMap(t -> t.get((Expression)keyPath), t -> t.get((Expression)valuePath), (t1, t2) -> t1));
    }

    protected <P> JPAQuery<P> timeout(JPAQuery<P> jpaQuery, int milliseconds) {
        jpaQuery.setHint("jakarta.persistence.query.timeout", (Object)("" + milliseconds));
        return jpaQuery;
    }

    protected NumberPath<Long> getIdPath() {
        return Expressions.numberPath(Long.class, this.qModel, (String)"id");
    }

    protected NumberPath<Integer> getDeleteFlagPath() {
        return Expressions.numberPath(Integer.class, this.qModel, (String)"deleteFlag");
    }

    protected Long getId(T data) {
        Assert.notNull(data, (String)"\u6570\u636e\u4e3a\u7a7a");
        if (data instanceof BaseModel) {
            return ((BaseModel)data).getId();
        }
        try {
            Method method = ReflectionUtils.findMethod(data.getClass(), (String)"getId");
            if (method != null) {
                return (Long)method.invoke(data, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalStateException("\u83b7\u53d6ID\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u5bf9\u8c61\u7c7b\u578b");
    }

    protected void setId(T data, Long id) {
        Assert.notNull(data, (String)"\u6570\u636e\u4e3a\u7a7a");
        if (data instanceof BaseModel) {
            ((BaseModel)data).setId(id);
        }
        try {
            Method method = ReflectionUtils.findMethod(data.getClass(), (String)"setId", (Class[])new Class[]{Long.class});
            if (method != null) {
                method.invoke(data, id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalStateException("\u8bbe\u7f6eID\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u5bf9\u8c61\u7c7b\u578b");
    }

    private boolean canUseCountWrapper(QueryMetadata queryMetadata, boolean usePaging) {
        if (queryMetadata.getHaving() != null) {
            return true;
        }
        if (!queryMetadata.getGroupBy().isEmpty() && queryMetadata.isDistinct()) {
            return true;
        }
        return !this.hasJoin(queryMetadata) && queryMetadata.getGroupBy().isEmpty();
    }

    private boolean hasJoin(QueryMetadata metadata) {
        List joins = metadata.getJoins();
        if (joins.isEmpty()) {
            return false;
        }
        if (joins.size() == 1) {
            return ((JoinExpression)joins.get(0)).getType() != JoinType.DEFAULT;
        }
        return true;
    }

    private OrderSpecifier<?> normalizeDefaultOrder(OrderSpecifier<?> defaultOrder) {
        if (defaultOrder == null) {
            return null;
        }
        return defaultOrder;
    }

    private <P, Q extends Path<P>> BooleanExpression fieldEq(@NotNull Q path, P value) {
        SimpleExpression p = (SimpleExpression)path;
        if (value == null) {
            return p.isNull();
        }
        return p.eq(value);
    }

    private <P, Q extends Path<P>> BooleanExpression fieldIn(@NotNull Q path, Collection<P> values) {
        SimpleExpression p = (SimpleExpression)path;
        return p.in(values);
    }

    private Expression<?> convertFieldExpression(String field) {
        if (this.pathBuilder == null) {
            this.pathBuilder = new PathBuilder(this.qModel.getClass(), this.qModel.getMetadata());
        }
        return this.pathBuilder.get(field);
    }

    private int obtainBatchSize() {
        return ((SessionImpl)this.entityManager.getDelegate()).getSessionFactory().getSessionFactoryOptions().getJdbcBatchSize();
    }

    @Autowired
    public void setJpaQueryFactory(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    @Autowired
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Autowired
    public void setCriteriaBuilderFactory(CriteriaBuilderFactory criteriaBuilderFactory) {
        this.criteriaBuilderFactory = criteriaBuilderFactory;
    }

    public static class PredicateBuilder {
        private final List<Predicate> conditions = new ArrayList<Predicate>();

        private PredicateBuilder() {
        }

        public static PredicateBuilder builder() {
            return new PredicateBuilder();
        }

        public PredicateBuilder and(Predicate predicate) {
            if (predicate != null) {
                this.conditions.add(predicate);
            }
            return this;
        }

        public PredicateBuilder and(boolean condition, @NotNull Supplier<Predicate> predicate) {
            Predicate predicateResult;
            if (condition && (predicateResult = predicate.get()) != null) {
                this.conditions.add(predicateResult);
            }
            return this;
        }

        public <T> PredicateBuilder andEq(@NotNull SimpleExpression<T> expression, T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)value))) {
                    this.conditions.add((Predicate)expression.eq(value));
                }
                return this;
            }
            if (value != null) {
                this.conditions.add((Predicate)expression.eq(value));
                return this;
            }
            return this;
        }

        public <T> PredicateBuilder andEq(boolean condition, @NotNull SimpleExpression<T> expression, T value) {
            if (condition) {
                this.conditions.add((Predicate)(value == null ? expression.isNull() : expression.eq(value)));
            }
            return this;
        }

        public <T> PredicateBuilder andEq(@NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> subQuery) {
            return this.andEq(true, expression, subQuery);
        }

        public <T> PredicateBuilder andEq(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> subQuery) {
            if (condition) {
                this.conditions.add((Predicate)expression.eq(subQuery));
            }
            return this;
        }

        public <T> PredicateBuilder andEq(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull Supplier<SubQueryExpression<T>> subQuery) {
            if (condition) {
                return this.andEq(true, expression, subQuery.get());
            }
            return this;
        }

        public <T> PredicateBuilder andNe(@NotNull SimpleExpression<T> expression, T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)value))) {
                    this.conditions.add((Predicate)expression.ne(value));
                }
                return this;
            }
            if (value != null) {
                this.conditions.add((Predicate)expression.ne(value));
                return this;
            }
            return this;
        }

        public <T> PredicateBuilder andNe(boolean condition, @NotNull SimpleExpression<T> expression, T value) {
            if (condition) {
                this.conditions.add((Predicate)(value == null ? expression.isNotNull() : expression.ne(value)));
            }
            return this;
        }

        public <T> PredicateBuilder andNe(@NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> subQuery) {
            return this.andNe(true, expression, subQuery);
        }

        public <T> PredicateBuilder andNe(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> subQuery) {
            if (condition) {
                this.conditions.add((Predicate)expression.ne(subQuery));
            }
            return this;
        }

        public <T> PredicateBuilder andNe(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull Supplier<SubQueryExpression<T>> subQuery) {
            if (!condition) {
                return this;
            }
            return this.andNe(true, expression, subQuery.get());
        }

        public <T extends Comparable<?>> PredicateBuilder andLt(@NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)((Object)value)))) {
                    this.conditions.add((Predicate)expression.lt(value));
                }
                return this;
            }
            return this.andLt(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andLt(boolean condition, @NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.lt(value));
            }
            return this;
        }

        public <T extends Number> PredicateBuilder andLt(@NotNull NumberExpression<T> expression, @NotNull T value) {
            return this.andLt(value != null, expression, value);
        }

        public <T extends Number> PredicateBuilder andLt(boolean condition, @NotNull NumberExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.lt(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andLoe(@NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)((Object)value)))) {
                    this.conditions.add((Predicate)expression.loe(value));
                }
                return this;
            }
            return this.andLoe(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andLoe(boolean condition, @NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.loe(value));
            }
            return this;
        }

        public <T extends Number> PredicateBuilder andLoe(@NotNull NumberExpression<T> expression, @NotNull T value) {
            return this.andLoe(value != null, expression, value);
        }

        public <T extends Number> PredicateBuilder andLoe(boolean condition, @NotNull NumberExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.loe(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andGt(@NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)((Object)value)))) {
                    this.conditions.add((Predicate)expression.gt(value));
                }
                return this;
            }
            return this.andGt(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andGt(boolean condition, @NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.gt(value));
            }
            return this;
        }

        public <T extends Number> PredicateBuilder andGt(@NotNull NumberExpression<T> expression, @NotNull T value) {
            return this.andGt(value != null, expression, value);
        }

        public <T extends Number> PredicateBuilder andGt(boolean condition, @NotNull NumberExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.gt(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andGoe(@NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)((Object)value)))) {
                    this.conditions.add((Predicate)expression.goe(value));
                }
                return this;
            }
            return this.andGoe(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andGoe(boolean condition, @NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.goe(value));
            }
            return this;
        }

        public <T extends Number> PredicateBuilder andGoe(@NotNull NumberExpression<T> expression, @NotNull T value) {
            return this.andGoe(value != null, expression, value);
        }

        public <T extends Number> PredicateBuilder andGoe(boolean condition, @NotNull NumberExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.goe(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andAfter(@NotNull TemporalExpression<T> expression, @NotNull T value) {
            return this.andAfter(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andAfter(boolean condition, @NotNull TemporalExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.after(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andBefore(@NotNull TemporalExpression<T> expression, @NotNull T value) {
            return this.andBefore(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andBefore(boolean condition, @NotNull TemporalExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.before(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andBetween(@NotNull TemporalExpression<T> expression, T start, T end) {
            return this.andBetween(true, expression, start, end);
        }

        public <T extends Comparable<?>> PredicateBuilder andBetween(boolean condition, @NotNull TemporalExpression<T> expression, T start, T end) {
            if (condition) {
                if (start != null && end != null) {
                    this.conditions.add((Predicate)expression.between(start, end));
                    return this;
                }
                if (start != null) {
                    this.conditions.add((Predicate)expression.after(start));
                }
                if (end != null) {
                    this.conditions.add((Predicate)expression.before(end));
                }
            }
            return this;
        }

        public <T> PredicateBuilder andNotNull(boolean condition, @NotNull SimpleExpression<T> expression) {
            if (condition) {
                this.conditions.add((Predicate)expression.isNotNull());
            }
            return this;
        }

        public <T> PredicateBuilder andIsNull(boolean condition, @NotNull SimpleExpression<T> expression) {
            if (condition) {
                this.conditions.add((Predicate)expression.isNull());
            }
            return this;
        }

        public PredicateBuilder andLike(@NotNull StringExpression expression, @NotBlank String value) {
            return this.andLike(StringUtils.hasText((String)value), expression, value);
        }

        public PredicateBuilder andLike(boolean condition, @NotNull StringExpression expression, @NotNull String value) {
            if (condition) {
                this.conditions.add((Predicate)expression.like(this.normalizeLikeValue(value)));
            }
            return this;
        }

        public PredicateBuilder andLike(@NotNull StringExpression[] expressions, @NotNull String value) {
            return this.andLike(StringUtils.hasText((String)value), expressions, value);
        }

        public PredicateBuilder andLike(boolean condition, @NotNull StringExpression[] expressions, @NotNull String value) {
            if (condition) {
                String keyword = this.normalizeLikeValue(value);
                BooleanExpression exp = null;
                for (StringExpression expression : expressions) {
                    if (expression == null) continue;
                    exp = exp == null ? expression.like(keyword) : exp.or((Predicate)expression.like(keyword));
                }
                this.conditions.add((Predicate)exp);
            }
            return this;
        }

        public PredicateBuilder andLike(@NotNull StringExpression expression, @NotEmpty Collection<String> values) {
            return this.andLike(CollUtil.isNotEmpty(values), expression, values);
        }

        public PredicateBuilder andLike(boolean condition, @NotNull StringExpression expression, @NotEmpty Collection<String> values) {
            Set<String> valList;
            if (!condition) {
                return this;
            }
            Set<String> set = valList = values == null ? Collections.emptySet() : values.stream().filter(StringUtils::hasText).collect(Collectors.toSet());
            if (valList.isEmpty()) {
                return this;
            }
            BooleanExpression exp = null;
            for (String v : valList) {
                exp = exp == null ? expression.like(this.normalizeLikeValue(v)) : exp.or((Predicate)expression.like(this.normalizeLikeValue(v)));
            }
            this.conditions.add((Predicate)exp);
            return this;
        }

        public PredicateBuilder andLeftLike(@NotNull StringExpression expression, @NotBlank String value) {
            return this.andLeftLike(StringUtils.hasText((String)value), expression, value);
        }

        public PredicateBuilder andLeftLike(boolean condition, @NotNull StringExpression expression, @NotBlank String value) {
            if (condition) {
                this.conditions.add((Predicate)expression.like("%" + value));
            }
            return this;
        }

        public PredicateBuilder andLeftLike(@NotNull StringExpression[] expressions, @NotBlank String value) {
            return this.andLeftLike(StringUtils.hasText((String)value), expressions, value);
        }

        public PredicateBuilder andLeftLike(boolean condition, @NotNull StringExpression[] expressions, @NotBlank String value) {
            if (condition) {
                String keyword = "%" + value;
                BooleanExpression exp = null;
                for (StringExpression expression : expressions) {
                    if (expression == null) continue;
                    exp = exp == null ? expression.like(keyword) : exp.or((Predicate)expression.like(keyword));
                }
                this.conditions.add((Predicate)exp);
            }
            return this;
        }

        public PredicateBuilder andLeftLike(@NotNull StringExpression expression, @NotEmpty Collection<String> values) {
            return this.andLeftLike(CollUtil.isNotEmpty(values), expression, values);
        }

        public PredicateBuilder andLeftLike(boolean condition, @NotNull StringExpression expression, @NotEmpty Collection<String> values) {
            Set<String> valList;
            if (!condition) {
                return this;
            }
            Set<String> set = valList = values == null ? Collections.emptySet() : values.stream().filter(StringUtils::hasText).collect(Collectors.toSet());
            if (valList.isEmpty()) {
                return this;
            }
            BooleanExpression exp = null;
            for (String v : valList) {
                exp = exp == null ? expression.like("%" + v) : exp.or((Predicate)expression.like("%" + v));
            }
            this.conditions.add((Predicate)exp);
            return this;
        }

        public PredicateBuilder andRightLike(@NotNull StringExpression expression, @NotBlank String value) {
            return this.andRightLike(StringUtils.hasText((String)value), expression, value);
        }

        public PredicateBuilder andRightLike(boolean condition, @NotNull StringExpression expression, @NotBlank String value) {
            if (condition) {
                this.conditions.add((Predicate)expression.like(value + "%"));
            }
            return this;
        }

        public PredicateBuilder andRightLike(@NotNull StringExpression[] expressions, @NotBlank String value) {
            return this.andRightLike(StringUtils.hasText((String)value), expressions, value);
        }

        public PredicateBuilder andRightLike(boolean condition, @NotNull StringExpression[] expressions, @NotBlank String value) {
            if (condition) {
                String keyword = value + "%";
                BooleanExpression exp = null;
                for (StringExpression expression : expressions) {
                    if (expression == null) continue;
                    exp = exp == null ? expression.like(keyword) : exp.or((Predicate)expression.like(keyword));
                }
                this.conditions.add((Predicate)exp);
            }
            return this;
        }

        public PredicateBuilder andRightLike(@NotNull StringExpression expression, @NotEmpty Collection<String> values) {
            return this.andRightLike(CollUtil.isNotEmpty(values), expression, values);
        }

        public PredicateBuilder andRightLike(boolean condition, @NotNull StringExpression expression, @NotEmpty Collection<String> values) {
            Set<String> valList;
            if (!condition) {
                return this;
            }
            Set<String> set = valList = values == null ? Collections.emptySet() : values.stream().filter(StringUtils::hasText).collect(Collectors.toSet());
            if (valList.isEmpty()) {
                return this;
            }
            BooleanExpression exp = null;
            for (String v : valList) {
                exp = exp == null ? expression.like(v + "%") : exp.or((Predicate)expression.like(v + "%"));
            }
            this.conditions.add((Predicate)exp);
            return this;
        }

        public <T> PredicateBuilder andIn(@NotNull SimpleExpression<T> expression, @NotEmpty Collection<T> value) {
            return this.andIn(CollUtil.isNotEmpty(value), expression, value);
        }

        public <T> PredicateBuilder andIn(@NotNull SimpleExpression<T> expression, T ... value) {
            return this.andIn(ArrayUtil.isNotEmpty((Object[])value), expression, value);
        }

        public <T> PredicateBuilder andIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotEmpty Collection<T> value) {
            if (condition) {
                Set valList;
                Set set = valList = value == null ? Collections.emptySet() : value.stream().filter(Objects::nonNull).collect(Collectors.toSet());
                if (CollUtil.isEmpty(valList)) {
                    return this;
                }
                this.conditions.add((Predicate)expression.in(valList));
            }
            return this;
        }

        public <T> PredicateBuilder andIn(boolean condition, @NotNull SimpleExpression<T> expression, T ... value) {
            if (condition) {
                Set valList;
                Set set = valList = ArrayUtil.isNotEmpty((Object[])value) ? Arrays.stream(value).filter(Objects::nonNull).collect(Collectors.toSet()) : Collections.emptySet();
                if (CollUtil.isEmpty(valList)) {
                    return this;
                }
                this.conditions.add((Predicate)expression.in(valList));
            }
            return this;
        }

        public <T> PredicateBuilder andIn(@NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> value) {
            this.conditions.add((Predicate)expression.in(value));
            return this;
        }

        public <T> PredicateBuilder andIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> value) {
            if (condition) {
                this.conditions.add((Predicate)expression.in(value));
            }
            return this;
        }

        public <T> PredicateBuilder andIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull Supplier<SubQueryExpression<T>> value) {
            if (!condition) {
                return this;
            }
            return this.andIn(true, expression, value.get());
        }

        public <T> PredicateBuilder andNotIn(@NotNull SimpleExpression<T> expression, @NotEmpty Collection<T> value) {
            return this.andNotIn(CollUtil.isNotEmpty(value), expression, value);
        }

        public <T> PredicateBuilder andNotIn(@NotNull SimpleExpression<T> expression, T ... value) {
            return this.andNotIn(ArrayUtil.isNotEmpty((Object[])value), expression, value);
        }

        public <T> PredicateBuilder andNotIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotEmpty Collection<T> value) {
            if (condition) {
                Set valList;
                Set set = valList = value == null ? Collections.emptySet() : value.stream().filter(Objects::nonNull).collect(Collectors.toSet());
                if (CollUtil.isEmpty(valList)) {
                    return this;
                }
                this.conditions.add((Predicate)expression.notIn(valList));
            }
            return this;
        }

        public <T> PredicateBuilder andNotIn(boolean condition, @NotNull SimpleExpression<T> expression, T ... value) {
            if (condition) {
                Set valList;
                Set set = valList = value == null ? Collections.emptySet() : Arrays.stream(value).filter(Objects::nonNull).collect(Collectors.toSet());
                if (CollUtil.isEmpty(valList)) {
                    return this;
                }
                this.conditions.add((Predicate)expression.notIn(valList));
            }
            return this;
        }

        public <T> PredicateBuilder andNotIn(@NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> value) {
            this.conditions.add((Predicate)expression.notIn(value));
            return this;
        }

        public <T> PredicateBuilder andNotIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> value) {
            if (condition) {
                this.conditions.add((Predicate)expression.notIn(value));
            }
            return this;
        }

        public <T> PredicateBuilder andNotIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull Supplier<SubQueryExpression<T>> value) {
            if (!condition) {
                return this;
            }
            return this.andNotIn(true, expression, value.get());
        }

        public PredicateBuilder andOnNotBlank(String field, @NotNull Supplier<Predicate> predicate) {
            if (CharSequenceUtil.isNotBlank((CharSequence)field)) {
                this.conditions.add(predicate.get());
            }
            return this;
        }

        public PredicateBuilder andOnNotNull(Object field, @NotNull Supplier<Predicate> predicate) {
            if (field != null) {
                this.conditions.add(predicate.get());
            }
            return this;
        }

        public PredicateBuilder andOnTrue(Boolean field, @NotNull Supplier<Predicate> predicate) {
            if (field != null && field.booleanValue()) {
                this.conditions.add(predicate.get());
            }
            return this;
        }

        public PredicateBuilder andOnFalse(Boolean field, @NotNull Supplier<Predicate> predicate) {
            if (field != null && !field.booleanValue()) {
                this.conditions.add(predicate.get());
            }
            return this;
        }

        public Predicate build() {
            if (this.conditions.isEmpty()) {
                return null;
            }
            return ExpressionUtils.allOf(this.conditions);
        }

        public Predicate buildOr() {
            if (this.conditions.isEmpty()) {
                return null;
            }
            return ExpressionUtils.anyOf(this.conditions);
        }

        private String normalizeLikeValue(String value) {
            if (value == null) {
                return null;
            }
            if (value.startsWith("%") || value.endsWith("%")) {
                return value;
            }
            return "%" + value + "%";
        }
    }
}

