/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.common;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.boot.jpa.common.EntityFilterHandler;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.hibernate.Filter;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;
import org.slf4j.Logger;

public class DefaultEntityFilterHandler
implements EntityFilterHandler {
    private static final Logger logger = CloudtBootLoggerFactory.REPO_JPA.getLogger(DefaultEntityFilterHandler.class);
    private final UserDetailProvider userProvider;

    public DefaultEntityFilterHandler(UserDetailProvider userProvider) {
        this.userProvider = userProvider;
    }

    @Override
    public void enableFilter(SessionImpl session) {
        Boolean isUseTenantOrg = (Boolean)ObjectUtil.defaultIfNull((Object)TenantOrgContext.isUseTenantOrg(), (Object)true);
        if (!isUseTenantOrg.booleanValue()) {
            return;
        }
        Long tenantOrgId = TenantOrgContext.getTenantOrg();
        if (tenantOrgId == null) {
            GeneralUserDetails currentUser;
            GeneralUserDetails generalUserDetails = currentUser = this.userProvider == null ? null : this.userProvider.currentUser();
            if (currentUser != null) {
                tenantOrgId = currentUser.getTenantOrgId();
            }
        }
        if (tenantOrgId == null) {
            return;
        }
        Filter filter = ((Session)session.unwrap(Session.class)).enableFilter("filterByTenantOrgId");
        filter.setParameter("tenant_org_id", (Object)tenantOrgId);
    }
}

