/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.service;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.context.ExecutorContextHolder;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.boot.log.service.DynamicMessageService;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OperationLogMqMessageServiceImpl
implements OperationLogMqMessageService {
    private static final Logger log = LoggerFactory.getLogger(OperationLogMqMessageServiceImpl.class);
    public static final String ARTIFICIAL = "artificial";
    private final DynamicMessageService messageService;
    private final Environment environment;
    private final TaskExecutor taskExecutor;
    private final String BINDING_NAME = "YST_OPERATION_LOG_TOPIC";
    private static final String BINDING_PREFIX = "elitesland.log.operation-log.topic.prefix";
    private static final String SPRING_APPLICATION_NAME = "spring.application.name";
    private static final String HEADER_MENU_CODE = "menuCode";
    private static final String BUSINESS_OBJECT_ENUM = "BusinessObjectEnum";
    String HEADER_KEYS = "KEYS";

    public OperationLogMqMessageServiceImpl(DynamicMessageService messageService, Environment environment, TaskExecutor taskExecutor) {
        this.messageService = messageService;
        this.environment = environment;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public ApiResult<String> sendSyncOperationLogMqMessage(OperationLogDTO operationLogDTO) {
        try {
            this.checkOperationLog(operationLogDTO);
            if (this.sendMessage(operationLogDTO)) {
                return ApiResult.ok();
            }
            return ApiResult.fail((String)"\u53d1\u9001\u8fd4\u56de\u5931\u8d25\u72b6\u6001");
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResult<String> sendAsyncOperationLogMqMessage(OperationLogDTO operationLogDTO) {
        try {
            this.checkOperationLog(operationLogDTO);
            CompletableFuture.runAsync(() -> this.sendMessage(operationLogDTO), (Executor)this.taskExecutor);
            return ApiResult.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return ApiResult.fail((String)e.getMessage());
        }
    }

    private boolean sendMessage(OperationLogDTO operationLogDTO) {
        String topicPrefix = this.environment.getProperty(BINDING_PREFIX, "");
        String messageKey = operationLogDTO.getTraceIdSys() + "_" + UUID.randomUUID();
        operationLogDTO.setExt3(topicPrefix + "YST_OPERATION_LOG_TOPIC_" + messageKey);
        Message message = MessageBuilder.withPayload((Object)operationLogDTO).setHeader(this.HEADER_KEYS, (Object)messageKey).build();
        boolean isSuccess = this.messageService.sendMessage(topicPrefix + "YST_OPERATION_LOG_TOPIC", message);
        if (isSuccess) {
            if (log.isDebugEnabled()) {
                log.debug("\u64cd\u4f5c\u65e5\u5fd7\u6d88\u606f\u53d1\u9001\uff1a{}-{}--{}", new Object[]{isSuccess, operationLogDTO, message});
            }
        } else {
            log.error("\u64cd\u4f5c\u65e5\u5fd7\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a{}-{}--{}", new Object[]{isSuccess, operationLogDTO, message});
        }
        return isSuccess;
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(Enum businessType, String businessParam, com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum operationType, String operationDescription) {
        if (!BUSINESS_OBJECT_ENUM.equals(businessType.getClass().getSimpleName())) {
            log.error("\u547d\u540d\u9519\u8bef\uff0c\u5bf9\u8c61\u7c7b\u578b\u679a\u4e3e\u7edf\u4e00\u547d\u540d\uff1aBusinessObjectEnum");
        }
        return this.quickNewOperationLogDTO(businessType.name(), businessParam, operationType, operationDescription);
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(Enum businessType, String businessParam, OperationTypeEnum operationType, String operationDescription) {
        if (!BUSINESS_OBJECT_ENUM.equals(businessType.getClass().getSimpleName())) {
            log.error("\u547d\u540d\u9519\u8bef\uff0c\u5bf9\u8c61\u7c7b\u578b\u679a\u4e3e\u7edf\u4e00\u547d\u540d\uff1aBusinessObjectEnum");
        }
        return this.quickNewOperationLogDTO(businessType.name(), businessParam, operationType, operationDescription);
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(String businessType, String businessParam, com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum operationType, String operationDescription) {
        OperationLogDTO operationLogDTO = OperationLogMqMessageServiceImpl.getOperationLogDTO(businessType, businessParam, operationType, operationDescription, this.environment);
        return operationLogDTO;
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(String businessType, String businessParam, OperationTypeEnum operationType, String operationDescription) {
        OperationLogDTO operationLogDTO = OperationLogMqMessageServiceImpl.getOperationLogDTO(businessType, businessParam, operationType, operationDescription, this.environment);
        return operationLogDTO;
    }

    public static OperationLogDTO getOperationLogDTO(String businessType, String businessParam, com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum operationType, String operationDescription, Environment environment) {
        OperationLogDTO operationLogDTO = OperationLogDTO.builder().build();
        operationLogDTO.setSource(ARTIFICIAL);
        operationLogDTO.setBusinessParam(businessParam);
        operationLogDTO.setBusinessType(businessType);
        operationLogDTO.setSuccess(true);
        operationLogDTO.setOperationType(operationType.name());
        operationLogDTO.setOperationTypeName(operationType.getDescription());
        operationLogDTO.setOperationDescription(operationDescription);
        operationLogDTO.setAppName(environment.getProperty(SPRING_APPLICATION_NAME));
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (HttpServletUtil.currentRequest() != null) {
            operationLogDTO.setMenuCode(request.getHeader(HEADER_MENU_CODE));
            operationLogDTO.setRequestUrl(request.getRequestURI());
            operationLogDTO.setRequestMethod(request.getMethod());
            operationLogDTO.setOperationIp(HttpServletUtil.currentClientIp());
        } else {
            operationLogDTO.setMenuCode("\u65e0\u83dc\u5355");
            operationLogDTO.setRequestUrl("\u975eHTTP\u8bf7\u6c42");
            operationLogDTO.setRequestMethod("\u975eHTTP\u8bf7\u6c42");
            log.info("HttpServletRequest Null");
        }
        operationLogDTO.setToken(SecurityContextUtil.currentToken());
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user != null) {
            operationLogDTO.setOperationUserName(user.getUsername());
            operationLogDTO.setOperationUserId(user.getUserId());
            operationLogDTO.setTenantId(user.getTenantId() == null ? -1L : user.getTenantId());
            operationLogDTO.setOperationName(user.getUser().getLastName());
        } else {
            operationLogDTO.setOperationUserName("\u65e0\u767b\u5f55\u4eba");
            operationLogDTO.setOperationUserId(0L);
            operationLogDTO.setTenantId(-1L);
            operationLogDTO.setOperationName("\u65e0\u767b\u5f55\u4eba");
            log.info("SecurityContextUtil.currentUser Null {}", (Object)operationLogDTO);
        }
        DateTime now = DateUtil.date();
        String formattedNow = DateUtil.format((Date)now, (String)"yyyy-MM-dd HH:mm:ss.SSS");
        operationLogDTO.setOperationTime(formattedNow);
        operationLogDTO.setTraceIdSys(MDC.get((String)"cloudt_traceId"));
        operationLogDTO.setTraceIdExt(TraceContext.traceId());
        return operationLogDTO;
    }

    public static OperationLogDTO getOperationLogDTO(String businessType, String businessParam, OperationTypeEnum operationType, String operationDescription, Environment environment) {
        OperationLogDTO operationLogDTO = OperationLogDTO.builder().build();
        operationLogDTO.setSource(ARTIFICIAL);
        operationLogDTO.setBusinessParam(businessParam);
        operationLogDTO.setBusinessType(businessType);
        operationLogDTO.setSuccess(true);
        operationLogDTO.setOperationType(operationType.name());
        operationLogDTO.setOperationTypeName(operationType.getDescription());
        operationLogDTO.setOperationDescription(operationDescription);
        operationLogDTO.setAppName(environment.getProperty(SPRING_APPLICATION_NAME));
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (request != null) {
            operationLogDTO.setMenuCode(request.getHeader(HEADER_MENU_CODE));
            operationLogDTO.setRequestUrl(request.getRequestURI());
            operationLogDTO.setRequestMethod(request.getMethod());
            operationLogDTO.setOperationIp(HttpServletUtil.currentClientIp());
        } else {
            operationLogDTO.setMenuCode("\u65e0\u83dc\u5355");
            operationLogDTO.setRequestUrl("\u975eHTTP\u8bf7\u6c42");
            operationLogDTO.setRequestMethod("\u975eHTTP\u8bf7\u6c42");
            log.info("HttpServletRequest Null");
        }
        operationLogDTO.setToken(SecurityContextUtil.currentToken());
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user != null) {
            operationLogDTO.setOperationUserName(user.getUsername());
            operationLogDTO.setOperationUserId(user.getUserId());
            operationLogDTO.setTenantId(user.getTenantId() == null ? -1L : user.getTenantId());
            operationLogDTO.setOperationName(user.getUser().getLastName());
        } else {
            operationLogDTO.setOperationUserName("\u65e0\u767b\u5f55\u4eba");
            operationLogDTO.setOperationUserId(0L);
            operationLogDTO.setTenantId(-1L);
            operationLogDTO.setOperationName("\u65e0\u767b\u5f55\u4eba");
            log.info("SecurityContextUtil.currentUser Null");
        }
        DateTime now = DateUtil.date();
        String formattedNow = DateUtil.format((Date)now, (String)"yyyy-MM-dd HH:mm:ss.SSS");
        operationLogDTO.setOperationTime(formattedNow);
        operationLogDTO.setTraceIdSys(MDC.get((String)"cloudt_traceId"));
        operationLogDTO.setTraceIdExt(TraceContext.traceId());
        ExecutorContextHolder.ExecutorContext executor = ExecutorContextHolder.get();
        if (executor != null) {
            operationLogDTO.setExecutorSource(executor.getSource().name());
        }
        return operationLogDTO;
    }

    private void checkOperationLog(OperationLogDTO operationLogDTO) {
        ExecutorContextHolder.ExecutorContext executor;
        Assert.hasText((String)operationLogDTO.getBusinessType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a");
        Assert.hasText((String)operationLogDTO.getBusinessParam(), (String)"\u4e1a\u52a1\u53c2\u6570\u4e3a\u7a7a");
        Assert.hasText((String)operationLogDTO.getOperationType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        Assert.hasText((String)operationLogDTO.getOperationDescription(), (String)"\u64cd\u4f5c\u63cf\u8ff0\u4e3a\u7a7a");
        Assert.hasText((String)operationLogDTO.getOperationTime(), (String)"\u64cd\u4f5c\u65f6\u95f4\u4e3a\u7a7a");
        if (operationLogDTO.getExecutorSource() == null && (executor = ExecutorContextHolder.get()) != null) {
            operationLogDTO.setExecutorSource(executor.getSource().name());
        }
    }
}

