/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.interceptor;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.common.TraceIdProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
@Order(value=0x7FFFFFFF)
public class TraceIdInterceptor
implements ResponseBodyAdvice<ApiResult<?>> {
    private final LogProperties logProperties;
    private final List<TraceIdProvider> providers;

    public TraceIdInterceptor(LogProperties logProperties, List<TraceIdProvider> providers) {
        this.logProperties = logProperties;
        this.providers = providers;
    }

    public boolean supports(@NonNull MethodParameter returnType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return ApiResult.class.isAssignableFrom(returnType.getParameterType());
    }

    public ApiResult<?> beforeBodyWrite(ApiResult<?> body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType, @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        if (body != null) {
            String traceId = this.getTraceId();
            body.setTraceId(traceId);
        }
        return body;
    }

    private String getTraceId() {
        if (CharSequenceUtil.isBlank((CharSequence)this.logProperties.getTrace().getTraceCode())) {
            return null;
        }
        for (TraceIdProvider provider : this.providers) {
            if (!this.logProperties.getTrace().getTraceCode().equals(provider.code())) continue;
            return provider.getTraceId();
        }
        return null;
    }
}

