/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.service;

import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.boot.log.service.DynamicMessageService;
import com.elitescloud.boot.log.service.OperationLogMqMessageDefaultServiceImpl;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class OperationLogMqMessageServiceImpl
implements OperationLogMqMessageService {
    private static final Logger log = LoggerFactory.getLogger(OperationLogMqMessageServiceImpl.class);
    public static final String ARTIFICIAL = "artificial";
    public static final String SPRING_APPLICATION_NAME = "spring.application.name";
    private final DynamicMessageService messageService;
    private final Environment environment;
    private final TaskExecutor taskExecutor;

    public OperationLogMqMessageServiceImpl(DynamicMessageService messageService, Environment environment, TaskExecutor taskExecutor) {
        this.messageService = messageService;
        this.environment = environment;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public ApiResult<String> sendSyncOperationLogMqMessage(OperationLogDTO operationLogDTO) {
        try {
            this.checkOperationLog(operationLogDTO);
            if (this.sendMessage(operationLogDTO)) {
                return ApiResult.ok();
            }
            return ApiResult.fail((String)"\u53d1\u9001\u8fd4\u56de\u5931\u8d25\u72b6\u6001");
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38\uff1a{}  {}", (Object)e.getMessage(), (Object)operationLogDTO);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResult<String> sendAsyncOperationLogMqMessage(OperationLogDTO operationLogDTO) {
        try {
            this.checkOperationLog(operationLogDTO);
            CompletableFuture.runAsync(() -> this.sendMessage(operationLogDTO), (Executor)this.taskExecutor);
            return ApiResult.ok();
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38\uff1a{}  {}", (Object)e.getMessage(), (Object)operationLogDTO);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    private boolean sendMessage(OperationLogDTO operationLogDTO) {
        String topicPrefix = this.environment.getProperty("elitesland.log.operation-log.topic.prefix", "");
        String messageKey = operationLogDTO.getTraceIdSys() + "_" + String.valueOf(UUID.randomUUID());
        operationLogDTO.setExt3(topicPrefix + "YST_OPERATION_LOG_TOPIC_" + messageKey);
        Message message = MessageBuilder.withPayload((Object)operationLogDTO).setHeader("KEYS", (Object)messageKey).build();
        boolean isSuccess = this.messageService.sendMessage(topicPrefix + "YST_OPERATION_LOG_TOPIC", message);
        if (isSuccess) {
            if (log.isDebugEnabled()) {
                log.debug("\u64cd\u4f5c\u65e5\u5fd7\u6d88\u606f\u53d1\u9001\uff1a{}-{}--{}", new Object[]{isSuccess, operationLogDTO, message});
            }
        } else {
            log.error("\u64cd\u4f5c\u65e5\u5fd7\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a{}-{}--{}", new Object[]{isSuccess, operationLogDTO, message});
        }
        return isSuccess;
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(Enum businessType, String businessParam, com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum operationType, String operationDescription) {
        if (!"BusinessObjectEnum".equals(businessType.getClass().getSimpleName())) {
            log.error("\u547d\u540d\u9519\u8bef\uff0c\u5bf9\u8c61\u7c7b\u578b\u679a\u4e3e\u7edf\u4e00\u547d\u540d\uff1aBusinessObjectEnum");
        }
        return this.quickNewOperationLogDTO(businessType.name(), businessParam, operationType, operationDescription);
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(Enum businessType, String businessParam, OperationTypeEnum operationType, String operationDescription) {
        if (!"BusinessObjectEnum".equals(businessType.getClass().getSimpleName())) {
            log.error("\u547d\u540d\u9519\u8bef\uff0c\u5bf9\u8c61\u7c7b\u578b\u679a\u4e3e\u7edf\u4e00\u547d\u540d\uff1aBusinessObjectEnum");
        }
        return this.quickNewOperationLogDTO(businessType.name(), businessParam, operationType, operationDescription);
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(String businessType, String businessParam, com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum operationType, String operationDescription) {
        OperationLogDTO operationLogDTO = OperationLogMqMessageDefaultServiceImpl.getOperationLogDTO(businessType, businessParam, operationType, operationDescription, this.environment);
        return operationLogDTO;
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(String businessType, String businessParam, OperationTypeEnum operationType, String operationDescription) {
        OperationLogDTO operationLogDTO = OperationLogMqMessageDefaultServiceImpl.getOperationLogDTO(businessType, businessParam, operationType, operationDescription, this.environment);
        return operationLogDTO;
    }
}

