/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log;

import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.common.LogStorable;
import com.elitescloud.boot.log.config.AccessLogConfig;
import com.elitescloud.boot.log.config.LogStorageConfig;
import com.elitescloud.boot.log.config.LoginLogConfig;
import com.elitescloud.boot.log.queue.LogEvent;
import com.elitescloud.boot.log.queue.LogEventFactory;
import com.elitescloud.boot.log.queue.LogEventHandler;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.concurrent.ThreadPoolExecutorFactoryBean;

@ConditionalOnProperty(prefix="elitesland.log", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={LogStorageConfig.class, LoginLogConfig.class, AccessLogConfig.class})
class CloudtLogAutoConfiguration {
    private static final Logger log = LogManager.getLogger(CloudtLogAutoConfiguration.class);
    private final LogProperties logProperties;

    public CloudtLogAutoConfiguration(LogProperties logProperties) {
        this.logProperties = logProperties;
    }

    @Bean(value={"logEventRingBuffer"})
    public RingBuffer<LogEvent> logEventRingBuffer(LogStorable storable) {
        int bufferSize = 262144;
        ThreadPoolExecutorFactoryBean executorFactoryBean = new ThreadPoolExecutorFactoryBean();
        LogProperties.ThreadPool threadPool = this.logProperties.getThreadPool();
        executorFactoryBean.setThreadNamePrefix(threadPool.getThreadNamePrefix());
        executorFactoryBean.setCorePoolSize(threadPool.getCoreSize().intValue());
        executorFactoryBean.setMaxPoolSize(threadPool.getMaxSize().intValue());
        Disruptor disruptor = new Disruptor((EventFactory)new LogEventFactory(), bufferSize, (ThreadFactory)executorFactoryBean, ProducerType.SINGLE, (WaitStrategy)new BlockingWaitStrategy());
        disruptor.handleEventsWith(new EventHandler[]{new LogEventHandler(storable)});
        disruptor.setDefaultExceptionHandler((ExceptionHandler)new ExceptionHandler<LogEvent>(){

            public void handleEventException(Throwable ex, long sequence, LogEvent event) {
                log.error("\u65e5\u5fd7\u5904\u7406\u5f02\u5e38\uff1a", ex);
            }

            public void handleOnStartException(Throwable ex) {
                log.error("\u65e5\u5fd7\u542f\u52a8\u5904\u7406\u5f02\u5e38\uff1a", ex);
            }

            public void handleOnShutdownException(Throwable ex) {
                log.error("\u65e5\u5fd7\u7ed3\u675f\u5904\u7406\u5f02\u5e38\uff1a", ex);
            }
        });
        disruptor.start();
        return disruptor.getRingBuffer();
    }
}

