/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.interceptor;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.common.RequestBodyDesensitize;
import com.elitescloud.boot.log.common.ResponseBodyDesensitize;
import com.elitescloud.boot.log.model.bo.AccessLogBO;
import com.elitescloud.boot.log.queue.LogEvent;
import com.elitescloud.boot.support.CloudtInterceptor;
import com.elitescloud.boot.threadpool.common.ThreadPoolHolder;
import com.elitescloud.boot.wrapper.CloudtRequestWrapper;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.lmax.disruptor.RingBuffer;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

@ControllerAdvice
@ConditionalOnBean(value={LogProperties.class})
public class AccessLogInterceptor<T extends Serializable>
implements CloudtInterceptor,
RequestBodyAdvice,
ResponseBodyAdvice<T> {
    private static final Logger logger = CloudtBootLoggerFactory.LOG_ACCESS.getLogger(AccessLogInterceptor.class);
    private final LogProperties configProperties;
    private final RingBuffer<LogEvent> ringBuffer;
    private final List<PathPattern> excludeRequestMatcher;
    private final List<PathPattern> includeRecordReqBodyMatcher;
    private final List<PathPattern> includeRecordRespBodyMatcher;
    private final Executor executor;
    private final ThreadLocal<AccessLogBO> accessLogThreadLocal = new ThreadLocal();
    private ErrorAttributes errorAttributes;
    private List<RequestBodyDesensitize> requestBodyDesensitizes;
    private List<ResponseBodyDesensitize> responseBodyDesensitizes;

    public AccessLogInterceptor(LogProperties configProperties, RingBuffer<LogEvent> ringBuffer) {
        this.configProperties = configProperties;
        this.ringBuffer = ringBuffer;
        this.excludeRequestMatcher = this.createExcludeRequestMatcher(configProperties.getAccessLog().getExcludedRequest());
        this.includeRecordReqBodyMatcher = this.convertRequestMatcher(configProperties.getAccessLog().getRecordRequestBody());
        this.includeRecordRespBodyMatcher = this.convertRequestMatcher(configProperties.getAccessLog().getRecordResponseBody());
        this.executor = this.createExecutor();
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (handler instanceof ResourceHttpRequestHandler || this.isMatch(request, this.excludeRequestMatcher)) {
            return true;
        }
        AccessLogBO logBo = new AccessLogBO();
        logBo.setRequestTime(LocalDateTime.now());
        this.accessLogThreadLocal.set(logBo);
        return true;
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        AccessLogBO accessLogBO = this.accessLogThreadLocal.get();
        this.accessLogThreadLocal.remove();
        if (accessLogBO == null) {
            return;
        }
        if (ex == null) {
            ex = (Exception)this.obtainException(request);
        }
        ((CompletableFuture)this.fillAccessLog(accessLogBO, request, handler, ex).thenAccept(this::addToQueue)).whenComplete((r, e) -> {
            if (e != null) {
                logger.error("\u7ec4\u88c5\u63a5\u53e3\u65e5\u5fd7\u53c2\u6570\u5f02\u5e38\uff1a", e);
            }
        });
    }

    public boolean supports(@NonNull MethodParameter methodParameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    @NonNull
    public HttpInputMessage beforeBodyRead(@NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        return inputMessage;
    }

    @NonNull
    public Object afterBodyRead(@NonNull Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        AccessLogBO accessLogBO = this.accessLogThreadLocal.get();
        if (accessLogBO != null) {
            List bodies = (List)ObjectUtil.defaultIfNull(accessLogBO.getRequestBody(), new ArrayList(4));
            bodies.add(body);
            accessLogBO.setRequestBody(bodies);
        }
        return body;
    }

    public Object handleEmptyBody(Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public boolean supports(@NonNull MethodParameter returnType, @NonNull Class converterType) {
        Class parameterType = returnType.getParameterType();
        return Serializable.class.isAssignableFrom(parameterType);
    }

    public T beforeBodyWrite(T body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType, @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        AccessLogBO accessLogBO = this.accessLogThreadLocal.get();
        if (accessLogBO != null) {
            accessLogBO.setResult(body);
        }
        return body;
    }

    @Autowired(required=false)
    public void setErrorAttributes(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    @Autowired
    public void setRequestBodyDesensitizeProvider(ObjectProvider<RequestBodyDesensitize> requestBodyDesensitizeProvider) {
        this.requestBodyDesensitizes = requestBodyDesensitizeProvider.stream().collect(Collectors.toList());
    }

    @Autowired
    public void setResponseBodyDesensitizeProvider(ObjectProvider<ResponseBodyDesensitize> requestBodyDesensitizeProvider) {
        this.responseBodyDesensitizes = requestBodyDesensitizeProvider.stream().collect(Collectors.toList());
    }

    private boolean isMatch(HttpServletRequest request, List<PathPattern> matchers) {
        if (matchers.isEmpty()) {
            return false;
        }
        PathContainer pathContainer = PathContainer.parsePath((String)request.getRequestURI());
        for (PathPattern requestMatcher : matchers) {
            if (!requestMatcher.matches(pathContainer)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(AccessLogBO accessLogBO) {
        long msgSequence = this.ringBuffer.next();
        try {
            ((LogEvent)this.ringBuffer.get(msgSequence)).setLog(accessLogBO);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u63a5\u53e3\u8bbf\u95ee\u65e5\u5fd7\u5230\u961f\u5217\u65f6\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            this.ringBuffer.publish(msgSequence);
        }
    }

    private CompletableFuture<AccessLogBO> fillAccessLog(AccessLogBO accessLogBO, HttpServletRequest request, Object handler, Exception ex) {
        Method handlerMethod;
        accessLogBO.setResponseTime(LocalDateTime.now());
        accessLogBO.setThreadId(Thread.currentThread().getName());
        accessLogBO.setTraceId(MDC.get((String)"cloudt_traceId"));
        Method method = handlerMethod = handler instanceof HandlerMethod ? ((HandlerMethod)handler).getMethod() : null;
        if (handlerMethod == null) {
            logger.warn("\u672a\u80fd\u8bc6\u522b\u7684\u65b9\u6cd5\u7c7b\u578b\uff1a{}", handler.getClass());
        }
        return CompletableFuture.supplyAsync(() -> {
            this.fillRequestInfo(accessLogBO, request, handlerMethod);
            this.fillResponseInfo(accessLogBO, request, handlerMethod, ex);
            return accessLogBO;
        }, this.executor);
    }

    private void fillRequestInfo(AccessLogBO accessLogBO, HttpServletRequest request, Method handlerMethod) {
        String token = SecurityContextUtil.currentToken();
        accessLogBO.setToken(token);
        accessLogBO.setUserAgent(request.getHeader("User-Agent"));
        accessLogBO.setMethod(request.getMethod());
        accessLogBO.setReqContentType(request.getContentType());
        accessLogBO.setUri(request.getRequestURI());
        accessLogBO.setOperation(this.obtainOperation(handlerMethod));
        accessLogBO.setReqIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        accessLogBO.setReqOuterIp(request.getRemoteAddr());
        accessLogBO.setQueryParams(request.getQueryString());
        if (accessLogBO.getRequestBody() != null && this.isMatch(request, this.includeRecordReqBodyMatcher)) {
            if (!this.requestBodyDesensitizes.isEmpty()) {
                for (RequestBodyDesensitize requestBodyDesensitize : this.requestBodyDesensitizes) {
                    if (!requestBodyDesensitize.support(handlerMethod, request)) continue;
                    ArrayList<Object> newBodies = new ArrayList<Object>(4);
                    for (Object obj : accessLogBO.getRequestBody()) {
                        Object newObj = requestBodyDesensitize.desensitize(obj);
                        if (newObj == null) continue;
                        newBodies.add(newObj);
                    }
                    accessLogBO.setRequestBody(newBodies);
                    break;
                }
            }
        } else {
            accessLogBO.setRequestBody(null);
        }
    }

    private void fillResponseInfo(AccessLogBO accessLogBO, HttpServletRequest request, Method handlerMethod, Throwable ex) {
        Object result = accessLogBO.getResult();
        if (result != null && this.isMatch(request, this.includeRecordRespBodyMatcher)) {
            if (!this.includeRecordRespBodyMatcher.isEmpty()) {
                for (ResponseBodyDesensitize responseBodyDesensitize : this.responseBodyDesensitizes) {
                    if (!responseBodyDesensitize.support(handlerMethod, request)) continue;
                    accessLogBO.setResult(responseBodyDesensitize.desensitize(result));
                    break;
                }
            }
        } else {
            accessLogBO.setResult(null);
        }
        if (result instanceof ApiResult) {
            ApiResult apiResult = (ApiResult)result;
            accessLogBO.setResultCode(apiResult.getCode());
            accessLogBO.setMsg(apiResult.getMsg());
        } else if (ex == null) {
            accessLogBO.setResultCode(HttpStatus.OK.value());
            accessLogBO.setMsg("\u64cd\u4f5c\u6210\u529f");
        } else if (ex instanceof BusinessException) {
            BusinessException exp = (BusinessException)ex;
            accessLogBO.setResultCode((Integer)ObjectUtil.defaultIfNull((Object)exp.getCode(), (Object)HttpStatus.INTERNAL_SERVER_ERROR.value()));
            accessLogBO.setMsg(CharSequenceUtil.blankToDefault((CharSequence)exp.getMessage(), (String)"\u64cd\u4f5c\u5931\u8d25"));
        } else {
            accessLogBO.setResultCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
            accessLogBO.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        accessLogBO.setThrowable(ex);
    }

    private String obtainOperation(Method method) {
        if (method == null) {
            return null;
        }
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        if (apiOperation != null) {
            return apiOperation.value();
        }
        return null;
    }

    private String obtainRequestBody(HttpServletRequest request) {
        if (request instanceof CloudtRequestWrapper) {
            return ((CloudtRequestWrapper)request).getBodyString();
        }
        return null;
    }

    private Throwable obtainException(HttpServletRequest request) {
        Throwable throwable = (Throwable)request.getAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE);
        if (throwable != null) {
            return throwable;
        }
        if (this.errorAttributes != null) {
            return this.errorAttributes.getError((WebRequest)new ServletWebRequest(request));
        }
        return null;
    }

    private List<PathPattern> createExcludeRequestMatcher(List<LogProperties.Matcher> matchers) {
        List requestMatchers = CloudtInterceptor.convert2RequestMatcher((Collection)CloudtInterceptor.staticResourcePatter());
        requestMatchers.addAll(this.convertRequestMatcher(matchers));
        return requestMatchers;
    }

    private List<PathPattern> convertRequestMatcher(List<LogProperties.Matcher> matchers) {
        if (CollectionUtils.isEmpty(matchers)) {
            return Collections.emptyList();
        }
        ArrayList<PathPattern> requestMatchers = new ArrayList<PathPattern>(matchers.size());
        for (LogProperties.Matcher matcher : matchers) {
            requestMatchers.add(PathPatternParser.defaultInstance.parse(matcher.getUri()));
        }
        return requestMatchers;
    }

    private Executor createExecutor() {
        LogProperties.ThreadPool threadPool = this.configProperties.getThreadPool();
        return ThreadPoolHolder.createThreadPool((String)threadPool.getThreadNamePrefix(), (Integer)threadPool.getCoreSize(), (Integer)threadPool.getMaxSize());
    }
}

