/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.core.logInfo;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Deprecated(forRemoval=true)
public class ApplicationStartedEventListener
implements GenericApplicationListener {
    private static final Logger logger = CloudtBootLoggerFactory.LOG.getLogger(ApplicationStartedEventListener.class);
    public static final int DEFAULT_ORDER = -2147483638;
    private static Class<?>[] EVENT_TYPES = new Class[]{ApplicationStartingEvent.class, ApplicationEnvironmentPreparedEvent.class, ApplicationPreparedEvent.class, ContextClosedEvent.class, ApplicationFailedEvent.class};
    private static Class<?>[] SOURCE_TYPES = new Class[]{SpringApplication.class, ApplicationContext.class};
    public static final String LOG_KAFKAURI = "kafkaUri";
    public static final String LOG_APPNAME = "appName";
    public static final String LOG_PORT = "port";
    public static final String LOG_GROUPNAME = "groupName";
    public static final String APP_KAFKAURI = "log4j2.kafka.uri";
    public static final String APP_APPNAME = "spring.application.name";
    public static final String APP_PORT = "server.port";
    public static final String APP_GROUPNAME = "log4j2.logext.groupName";
    public static final String APP_D_KAFKAURI = "LOG4J2_KAFKA_URI";
    public static final String APP_D_APPNAME = "SPRING_APPLICATION_NAME";
    public static final String APP_D_PORT = "SERVER_PORT";
    public static final String APP_D_GROUPNAME = "LOG4J2_LOGEXT_GROUPNAME";

    public void onApplicationEvent(ApplicationEvent event) {
        logger.info("----------------------log4j\u4e0a\u4e0b\u6587\u73af\u5883\u53d8\u91cf\u52a0\u8f7d----------------------------");
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            ConfigurableEnvironment envi = ((ApplicationEnvironmentPreparedEvent)event).getEnvironment();
            MutablePropertySources mps = envi.getPropertySources();
            for (PropertySource propertySource : mps) {
                if (propertySource.getName().contains("applicationConfig: [classpath:/config/application.yml]")) {
                    Object port;
                    String appName;
                    logger.info("---------------------- \u53d8\u91cf\u8bfb\u53d6 application.yml----------------------------" + propertySource.getProperty(APP_APPNAME));
                    if (propertySource.containsProperty(APP_APPNAME) && (appName = propertySource.getProperty(APP_APPNAME).toString()) != null) {
                        MDC.put((String)LOG_APPNAME, (String)appName);
                    }
                    logger.info("---------------------- \u53d8\u91cf\u8bfb\u53d6 application.yml----------------------------" + propertySource.getProperty(APP_PORT));
                    if (propertySource.containsProperty(APP_PORT) && (port = propertySource.getProperty(APP_PORT)) != null) {
                        MDC.put((String)LOG_PORT, (String)port.toString());
                    }
                    logger.info("---------------------- \u53d8\u91cf\u8bfb\u53d6 application.yml----------------------------" + propertySource.getProperty(APP_KAFKAURI));
                    if (propertySource.containsProperty(APP_KAFKAURI)) {
                        MDC.put((String)LOG_KAFKAURI, (String)((String)propertySource.getProperty(APP_KAFKAURI)));
                    }
                    logger.info("---------------------- \u53d8\u91cf\u8bfb\u53d6 application.yml----------------------------" + propertySource.getProperty(APP_GROUPNAME));
                    if (!propertySource.containsProperty(APP_GROUPNAME)) continue;
                    MDC.put((String)LOG_GROUPNAME, (String)((String)propertySource.getProperty(APP_GROUPNAME)));
                    continue;
                }
                if (!propertySource.getName().contains("applicationConfig:")) continue;
                logger.info("---------------------- \u53d8\u91cf\u8bfb\u53d6 applicationConfig\uff1a----------------------------" + propertySource.getProperty(APP_KAFKAURI));
                if (!propertySource.containsProperty(APP_KAFKAURI)) continue;
                MDC.put((String)LOG_KAFKAURI, (String)((String)propertySource.getProperty(APP_KAFKAURI)));
            }
            String ip = ApplicationStartedEventListener.getIp();
            if (StringUtils.isNotBlank((CharSequence)ip)) {
                MDC.put((String)"ip", (String)ip);
            }
        }
        this.setServiceSystemEnv();
        logger.info("----------------------log4j\u4e0a\u4e0b\u6587\u73af\u5883\u53d8\u91cf\u52a0\u8f7dend----------------------------");
    }

    private void setServiceSystemEnv() {
        String kafkaUriEnv = System.getenv().get(APP_KAFKAURI);
        String groupNameEnv = System.getenv().get(APP_GROUPNAME);
        String appNameEnv = System.getenv().get(APP_APPNAME);
        String appPort = System.getenv().get(APP_PORT);
        logger.info("---------------------- system\u7cfb\u7edf\u73af\u5883\u53d8\u91cf\u8bfb\u53d6 kafkaUriEnv ----------------------------" + kafkaUriEnv);
        logger.info("---------------------- system\u7cfb\u7edf\u73af\u5883\u53d8\u91cf\u8bfb\u53d6 kafkaUriEnv ----------------------------" + groupNameEnv);
        logger.info("---------------------- system\u7cfb\u7edf\u73af\u5883\u53d8\u91cf\u8bfb\u53d6 appNameEnv ----------------------------" + appNameEnv);
        logger.info("---------------------- system\u7cfb\u7edf\u73af\u5883\u53d8\u91cf\u8bfb\u53d6 appPort ----------------------------" + appPort);
        if (kafkaUriEnv != null && kafkaUriEnv.length() > 0) {
            MDC.put((String)LOG_KAFKAURI, (String)kafkaUriEnv);
        } else {
            kafkaUriEnv = System.getenv().get(APP_D_KAFKAURI);
            if (kafkaUriEnv != null && kafkaUriEnv.length() > 0) {
                MDC.put((String)LOG_KAFKAURI, (String)kafkaUriEnv);
            }
        }
        if (groupNameEnv != null && groupNameEnv.length() > 0) {
            MDC.put((String)LOG_GROUPNAME, (String)groupNameEnv);
        } else {
            groupNameEnv = System.getenv().get(APP_D_GROUPNAME);
            if (groupNameEnv != null && groupNameEnv.length() > 0) {
                MDC.put((String)LOG_GROUPNAME, (String)groupNameEnv);
            }
        }
        if (appNameEnv != null && appNameEnv.length() > 0) {
            MDC.put((String)LOG_APPNAME, (String)appNameEnv);
        } else {
            appNameEnv = System.getenv().get(APP_D_APPNAME);
            if (appNameEnv != null && appNameEnv.length() > 0) {
                MDC.put((String)LOG_APPNAME, (String)appNameEnv);
            }
        }
        if (appPort != null && appPort.length() > 0) {
            MDC.put((String)LOG_PORT, (String)appPort);
        } else {
            appPort = System.getenv().get(APP_D_PORT);
            if (appPort != null && appPort.length() > 0) {
                MDC.put((String)LOG_PORT, (String)appPort);
            }
        }
    }

    public int getOrder() {
        return -2147483638;
    }

    public boolean supportsEventType(ResolvableType resolvableType) {
        return this.isAssignableFrom(resolvableType.getRawClass(), EVENT_TYPES);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return this.isAssignableFrom(sourceType, SOURCE_TYPES);
    }

    private boolean isAssignableFrom(Class<?> type, Class<?> ... supportedTypes) {
        if (type != null) {
            for (Class<?> supportedType : supportedTypes) {
                if (!supportedType.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getIp() {
        InetAddress ip;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "";
        }
        return ip.getHostAddress();
    }
}

