/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.config;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.common.LogStorable;
import com.elitescloud.boot.log.config.AccessLogConfig;
import com.elitescloud.boot.log.model.bo.LoginLogBO;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@ConditionalOnProperty(prefix="elitesland.log.login-log", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LoginLogConfig
implements SchedulingConfigurer {
    private static final Logger logger = CloudtBootLoggerFactory.LOG_ACCESS.getLogger(AccessLogConfig.class);
    private final LogProperties logProperties;
    private LogStorable logStorable;

    public LoginLogConfig(LogProperties logProperties) {
        this.logProperties = logProperties;
        logger.info("\u542f\u7528\u767b\u5f55\u65e5\u5fd7\u8bb0\u5f55");
    }

    public void configureTasks(@NonNull ScheduledTaskRegistrar taskRegistrar) {
        Duration ttl = this.logProperties.getLoginLog().getTimeToLive();
        if (ttl == null || ttl.toSeconds() < 1L) {
            return;
        }
        taskRegistrar.addFixedDelayTask(() -> this.clearExpiredLog(ttl), TimeUnit.HOURS.toMillis(2L));
    }

    @Autowired
    public void setLogStorable(LogStorable logStorable) {
        this.logStorable = logStorable;
    }

    private void clearExpiredLog(Duration ttl) {
        try {
            this.logStorable.clearExpired(LoginLogBO.class, LocalDateTime.now().minusSeconds(ttl.toSeconds()));
        }
        catch (Exception e) {
            logger.error("\u6e05\u7406\u8fc7\u671f\u767b\u5f55\u65e5\u5fd7\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

