/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.log.interceptor.BusinessOperationLogAspect;
import com.elitescloud.boot.log.service.DynamicMessageService;
import com.elitescloud.boot.log.service.OperationLogMqMessageDefaultServiceImpl;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitescloud.boot.log.service.OperationLogMqMessageServiceImpl;
import com.elitescloud.boot.log.service.OperationLogRedisMqMessageServiceImpl;
import com.elitescloud.boot.wrapper.RedisWrapper;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;

@ConditionalOnProperty(prefix="elitesland.log", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={StreamBridge.class, RedisTemplate.class})
public class CloudOperationLogAutoConfiguration {
    private static final Logger logger = CloudtBootLoggerFactory.LOG_OPERATION.getLogger(CloudOperationLogAutoConfiguration.class);

    public CloudOperationLogAutoConfiguration() {
        logger.info("\u542f\u7528\u64cd\u4f5c\u65e5\u5fd7");
    }

    @Bean
    public DynamicMessageService dynamicMessageService(StreamBridge streamBridge) {
        return new DynamicMessageService(streamBridge);
    }

    @Bean
    @ConditionalOnMissingBean
    public OperationLogMqMessageService operationLogMqMessageService(Environment environment) {
        logger.info("\u6ca1\u6709\u914d\u7f6e\u6216\u5f00\u542f\u64cd\u4f5c\u65e5\u5fd7\u6d88\u606f\u961f\u5217\u914d\u7f6e\uff0c\u9ed8\u8ba4\u91c7\u7528\u7cfb\u7edflog\u65e5\u5fd7\u8f93\u51fa");
        return new OperationLogMqMessageDefaultServiceImpl(environment);
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.log.operation-log", name={"enabled"}, havingValue="true")
    public OperationLogMqMessageService operationLogMqMessageService(Environment environment, DynamicMessageService dynamicMessageService, TaskExecutor taskExecutor, RedisTemplate<String, String> redisTemplate, RedisWrapper redisWrappe) {
        String mqServiceType = environment.getProperty("elitesland.log.operation-log.mq-service-type");
        if (mqServiceType == null || "".equals(mqServiceType) || "mq".equals(mqServiceType)) {
            logger.info("\u91c7\u7528MQ\u4e2d\u95f4\u4ef6\u53d1\u9001\u64cd\u4f5c\u65e5\u5fd7\uff1a" + mqServiceType);
            return new OperationLogMqMessageServiceImpl(dynamicMessageService, environment, taskExecutor);
        }
        if ("redis".equals(mqServiceType)) {
            logger.info("\u91c7\u7528Redis\u4e2d\u95f4\u4ef6\u53d1\u9001\u64cd\u4f5c\u65e5\u5fd7\uff1a" + mqServiceType);
            return new OperationLogRedisMqMessageServiceImpl(environment, taskExecutor, redisTemplate, redisWrappe);
        }
        logger.error("\u6ca1\u6709\u6b63\u786e\u7684\u64cd\u4f5c\u65e5\u5fd7\u6d88\u606f\u961f\u5217\u5b9e\u73b0\u914d\u7f6e\uff0c\u9ed8\u8ba4\u91c7\u7528log\u65e5\u5fd7\u8f93\u51fa");
        return new OperationLogMqMessageDefaultServiceImpl(environment);
    }

    @ConditionalOnProperty(prefix="elitesland.log.operation-log-aspect", name={"enabled"}, havingValue="true")
    @Bean
    BusinessOperationLogAspect businessOperationLogAspect(OperationLogMqMessageService operationLogService) {
        return new BusinessOperationLogAspect(operationLogService);
    }
}

