/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log;

import com.elitescloud.boot.log.config.LogRepositoryProperties;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="elitesland.log")
public class LogProperties {
    public static final String CONFIG_PREFIX = "elitesland.log";
    public static final String OPERATION_LOG = ".operation-log";
    public static final String MQ_SERVICE_TYPE = ".mq-service-type";
    public static final String BINDING_PREFIX = "elitesland.log.topic.prefix";
    private Boolean enabled = true;
    @NestedConfigurationProperty
    private final ThreadPool threadPool = new ThreadPool();
    @NestedConfigurationProperty
    private LogRepositoryProperties repository = new LogRepositoryProperties();
    @Valid
    @NestedConfigurationProperty
    private AccessLog accessLog = new AccessLog();
    @NestedConfigurationProperty
    private LoginLog loginLog = new LoginLog();
    @NestedConfigurationProperty
    private OperationLog operationLog = new OperationLog();
    @NestedConfigurationProperty
    private Trace trace = new Trace();
    private Map<String, LogAppender> cloudtAppenders = new HashMap<String, LogAppender>();

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setRepository(LogRepositoryProperties repository) {
        this.repository = repository;
    }

    public LogRepositoryProperties getRepository() {
        return this.repository;
    }

    public AccessLog getAccessLog() {
        return this.accessLog;
    }

    public LoginLog getLoginLog() {
        return this.loginLog;
    }

    public void setAccessLog(AccessLog accessLog) {
        this.accessLog = accessLog;
    }

    public void setLoginLog(LoginLog loginLog) {
        this.loginLog = loginLog;
    }

    public OperationLog getOperationLog() {
        return this.operationLog;
    }

    public void setOperationLog(OperationLog operationLog) {
        this.operationLog = operationLog;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public void setTrace(Trace trace) {
        this.trace = trace;
    }

    public Map<String, LogAppender> getCloudtAppenders() {
        return this.cloudtAppenders;
    }

    public void setCloudtAppenders(Map<String, LogAppender> cloudtAppenders) {
        this.cloudtAppenders = cloudtAppenders;
    }

    public static class ThreadPool {
        private String threadNamePrefix = "cloudt-log-";
        private Integer coreSize = 8;
        private Integer maxSize = 64;

        public String getThreadNamePrefix() {
            return this.threadNamePrefix;
        }

        public void setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
        }

        public Integer getCoreSize() {
            return this.coreSize;
        }

        public void setCoreSize(Integer coreSize) {
            this.coreSize = coreSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class AccessLog {
        private Boolean enabled = false;
        @Valid
        private List<Matcher> excludedRequest;
        @Valid
        private List<Matcher> recordResponseBody;
        @Valid
        private List<Matcher> recordRequestBody;
        private Integer max = 512;
        private Duration persistenceRate = Duration.ofSeconds(20L);
        private Duration timeToLive = Duration.ofDays(30L);

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public List<Matcher> getExcludedRequest() {
            return this.excludedRequest;
        }

        public void setExcludedRequest(List<Matcher> excludedRequest) {
            this.excludedRequest = excludedRequest;
        }

        public List<Matcher> getRecordResponseBody() {
            return this.recordResponseBody;
        }

        public void setRecordResponseBody(List<Matcher> recordResponseBody) {
            this.recordResponseBody = recordResponseBody;
        }

        public List<Matcher> getRecordRequestBody() {
            return this.recordRequestBody;
        }

        public void setRecordRequestBody(List<Matcher> recordRequestBody) {
            this.recordRequestBody = recordRequestBody;
        }

        public Integer getMax() {
            return this.max;
        }

        public void setMax(Integer max) {
            this.max = max;
        }

        public Duration getPersistenceRate() {
            return this.persistenceRate;
        }

        public void setPersistenceRate(Duration persistenceRate) {
            this.persistenceRate = persistenceRate;
        }

        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
        }
    }

    public static class LoginLog {
        private Boolean enabled = true;
        private Boolean userDetail = false;
        private Duration timeToLive = Duration.ofDays(180L);

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Boolean getUserDetail() {
            return this.userDetail;
        }

        public void setUserDetail(Boolean userDetail) {
            this.userDetail = userDetail;
        }

        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
        }
    }

    public static class OperationLog {
        private Boolean enabled = true;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Trace {
        private String traceCode = "skywalking";

        public String getTraceCode() {
            return this.traceCode;
        }

        public void setTraceCode(String traceCode) {
            this.traceCode = traceCode;
        }
    }

    public static class LogAppender {
        @NotBlank
        private String filePattern = "${basePath}/%d{yyyy-MM}/cloudt-%d{yyyy-MM-dd}-%i.log.gz";
        private String fileName = "${basePath}/cloudt.log";
        private String layoutPattern = "[${APP_GROUP}][${APP_NAME}][%d{yyyy-MM-dd HH:mm:ss.SSS}][%-5level][source:%X{cloudt_source}][group:%logger][cloudt:%X{cloudt_traceId}][requestId:%X{requestId}] [threadId:%t] [traceId-%traceId] %l - %m%n";
        private int timeBasedTriggerPolicyInterval = 12;
        private boolean timeBasedTriggerPolicyModulate = true;
        private String sizedBasedTriggerPolicySize = "20MB";
        private String rolloverStrategyMax = "500";
        private List<String> filterLevels = List.of("ALL");
        private Set<String> filterLogNames = Set.of("*");

        public String getFilePattern() {
            return this.filePattern;
        }

        public void setFilePattern(String filePattern) {
            this.filePattern = filePattern;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getLayoutPattern() {
            return this.layoutPattern;
        }

        public void setLayoutPattern(String layoutPattern) {
            this.layoutPattern = layoutPattern;
        }

        public int getTimeBasedTriggerPolicyInterval() {
            return this.timeBasedTriggerPolicyInterval;
        }

        public void setTimeBasedTriggerPolicyInterval(int timeBasedTriggerPolicyInterval) {
            this.timeBasedTriggerPolicyInterval = timeBasedTriggerPolicyInterval;
        }

        public boolean isTimeBasedTriggerPolicyModulate() {
            return this.timeBasedTriggerPolicyModulate;
        }

        public void setTimeBasedTriggerPolicyModulate(boolean timeBasedTriggerPolicyModulate) {
            this.timeBasedTriggerPolicyModulate = timeBasedTriggerPolicyModulate;
        }

        public String getSizedBasedTriggerPolicySize() {
            return this.sizedBasedTriggerPolicySize;
        }

        public void setSizedBasedTriggerPolicySize(String sizedBasedTriggerPolicySize) {
            this.sizedBasedTriggerPolicySize = sizedBasedTriggerPolicySize;
        }

        public String getRolloverStrategyMax() {
            return this.rolloverStrategyMax;
        }

        public void setRolloverStrategyMax(String rolloverStrategyMax) {
            this.rolloverStrategyMax = rolloverStrategyMax;
        }

        public List<String> getFilterLevels() {
            return this.filterLevels;
        }

        public void setFilterLevels(List<String> filterLevels) {
            this.filterLevels = filterLevels;
        }

        public Set<String> getFilterLogNames() {
            return this.filterLogNames;
        }

        public void setFilterLogNames(Set<String> filterLogNames) {
            this.filterLogNames = filterLogNames;
        }
    }

    @Validated
    public static class Matcher {
        @NotBlank(message="uri\u4e0d\u80fd\u4e3a\u7a7a")
        @Pattern(regexp="/[^?#]*", message="uri\u5fc5\u987b\u4ee5/\u5f00\u59cb")
        private @NotBlank(message="uri\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="/[^?#]*", message="uri\u5fc5\u987b\u4ee5/\u5f00\u59cb") String uri;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }
    }
}

