/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.config;

import cn.hutool.core.text.CharSequenceUtil;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.common.LogStorable;
import com.elitescloud.boot.log.config.AccessLogConfig;
import com.elitescloud.boot.log.config.LogRepositoryProperties;
import com.elitescloud.boot.log.provider.storage.DatabaseStorage;
import com.elitescloud.boot.log.provider.storage.ElasticsearchStorage;
import com.elitescloud.boot.log.provider.storage.EmptyStorage;
import com.elitescloud.boot.log.provider.storage.LogPrintStorage;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Import(value={ElasticsearchStorageConfig.class, DatabaseStorageConfig.class})
public class LogStorageConfig {
    private static final Logger logger = CloudtBootLoggerFactory.LOG.getLogger(AccessLogConfig.class);
    private final LogProperties logProperties;

    public LogStorageConfig(LogProperties logProperties) {
        this.logProperties = logProperties;
    }

    @ConditionalOnProperty(prefix="elitesland.log.repository", name={"storage-type"}, havingValue="log")
    @Bean
    public LogStorable logPrintStorage() {
        logger.info("\u65e5\u5fd7\u6301\u4e45\u5316\u65b9\u5f0f\uff1a{}", (Object)this.logProperties.getRepository().getStorageType());
        return new LogPrintStorage(this.logProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public LogStorable logStorable() {
        logger.info("\u65e5\u5fd7\u6301\u4e45\u5316\u65b9\u5f0f\uff1a{}", (Object)"\u4e0d\u5b58\u50a8");
        return new EmptyStorage();
    }

    @ConditionalOnClass(value={ElasticsearchClient.class})
    @ConditionalOnProperty(prefix="elitesland.log.repository", name={"storage-type"}, havingValue="elasticsearch")
    static class ElasticsearchStorageConfig {
        ElasticsearchStorageConfig() {
        }

        @Bean
        public LogStorable logStorableElasticsearch(LogProperties logProperties, Jackson2ObjectMapperBuilder objectMapperBuilder) {
            logger.info("\u65e5\u5fd7\u6301\u4e45\u5316\u65b9\u5f0f\uff1a{}", (Object)logProperties.getRepository().getStorageType());
            LogRepositoryProperties.Elasticsearch elasticsearch = logProperties.getRepository().getElasticsearch();
            Object[] httpHosts = new HttpHost[]{};
            if (!CollectionUtils.isEmpty(elasticsearch.getUris())) {
                httpHosts = (HttpHost[])elasticsearch.getUris().stream().filter(CharSequenceUtil::isNotBlank).map(HttpHost::create).toArray(HttpHost[]::new);
            }
            Assert.notEmpty((Object[])httpHosts, (String)"\u65e5\u5fd7\u5b58\u50a8\u7684Elasticsearch\u5730\u5740\u672a\u914d\u7f6e");
            JacksonJsonpMapper jsonpMapper = new JacksonJsonpMapper(objectMapperBuilder.build());
            RestClientTransport transport = new RestClientTransport(RestClient.builder((HttpHost[])httpHosts).build(), (JsonpMapper)jsonpMapper);
            ElasticsearchClient elasticsearchClient = new ElasticsearchClient((ElasticsearchTransport)transport);
            return new ElasticsearchStorage(logProperties, elasticsearchClient);
        }
    }

    @ConditionalOnProperty(prefix="elitesland.log.repository", name={"storage-type"}, havingValue="database")
    static class DatabaseStorageConfig {
        private final LogProperties logProperties;

        public DatabaseStorageConfig(LogProperties logProperties) {
            this.logProperties = logProperties;
        }

        @Bean
        public LogStorable databasePrintStorage() {
            logger.info("\u65e5\u5fd7\u6301\u4e45\u5316\u65b9\u5f0f\uff1a{}", (Object)this.logProperties.getRepository().getStorageType());
            return new DatabaseStorage(this.logProperties);
        }
    }
}

