/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.ai.util.json.schema;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import com.elitescloud.boot.ai.util.json.schema.CloudtSpringAiSchemaModule;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.swagger2.Swagger2Module;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.ai.util.json.JsonParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;

public final class CloudtJsonSchemaGenerator {
    private static final boolean PROPERTY_REQUIRED_BY_DEFAULT = true;
    private static final SchemaGenerator TYPE_SCHEMA_GENERATOR;
    private static final SchemaGenerator SUBTYPE_SCHEMA_GENERATOR;

    private CloudtJsonSchemaGenerator() {
    }

    public static String generateForMethodInput(Method method, SchemaOption ... schemaOptions) {
        ObjectNode schema = JsonParser.getObjectMapper().createObjectNode();
        schema.put("$schema", SchemaVersion.DRAFT_2020_12.getIdentifier());
        schema.put("type", "object");
        ObjectNode properties = schema.putObject("properties");
        ArrayList<String> required = new ArrayList<String>();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Class parameterClass;
            String parameterName = CloudtJsonSchemaGenerator.getMethodParameterName(method.getParameters()[i]);
            Type parameterType = method.getGenericParameterTypes()[i];
            if (parameterType instanceof Class && ClassUtils.isAssignable((Class)(parameterClass = (Class)parameterType), ToolContext.class)) continue;
            Class clazz = parameterClass = parameterType instanceof Class ? (Class)parameterType : null;
            if (parameterClass != null && (ClassUtils.isAssignable((Class)parameterClass, HttpServletRequest.class) || ClassUtils.isAssignable((Class)parameterClass, HttpServletResponse.class))) continue;
            if (CloudtJsonSchemaGenerator.isMethodParameterRequired(method, i)) {
                required.add(parameterName);
            }
            ObjectNode parameterNode = SUBTYPE_SCHEMA_GENERATOR.generateSchema(parameterType, new Type[0]);
            if (parameterClass != null && !ClassUtil.isSimpleTypeOrArray((Class)parameterClass)) {
                required.remove(parameterName);
                JsonNode childProperties = parameterNode.findValue("properties");
                if (childProperties == null || !childProperties.isObject()) continue;
                ArrayList childPropertyRequired = new ArrayList();
                parameterNode.withArray("required").elements().forEachRemaining(t -> childPropertyRequired.add(t.asText()));
                childProperties.fieldNames().forEachRemaining(t -> {
                    JsonNode childProperty = childProperties.findValue(t);
                    properties.putIfAbsent(t, childProperty);
                    if (childPropertyRequired.contains(t)) {
                        required.add((String)t);
                    }
                });
                continue;
            }
            String parameterDescription = CloudtJsonSchemaGenerator.getMethodParameterDescription(method, i);
            if (StringUtils.hasText((String)parameterDescription)) {
                parameterNode.put("description", parameterDescription);
            }
            properties.set(parameterName, (JsonNode)parameterNode);
        }
        ArrayNode requiredArray = schema.putArray("required");
        required.forEach(arg_0 -> ((ArrayNode)requiredArray).add(arg_0));
        CloudtJsonSchemaGenerator.processSchemaOptions(schemaOptions, schema);
        return schema.toPrettyString();
    }

    public static String getMethodParameterName(Parameter parameter) {
        String parameterName;
        RequestParam parameterAnno = parameter.getAnnotation(RequestParam.class);
        if (parameterAnno != null && CharSequenceUtil.isNotBlank((CharSequence)(parameterName = CharSequenceUtil.blankToDefault((CharSequence)parameterAnno.value(), (String)parameterAnno.name())))) {
            return parameterName;
        }
        return parameter.getName();
    }

    public static String generateForType(Type type, SchemaOption ... schemaOptions) {
        Assert.notNull((Object)type, (String)"type cannot be null");
        ObjectNode schema = TYPE_SCHEMA_GENERATOR.generateSchema(type, new Type[0]);
        if (type == Void.class && !schema.has("properties")) {
            schema.putObject("properties");
        }
        CloudtJsonSchemaGenerator.processSchemaOptions(schemaOptions, schema);
        return schema.toPrettyString();
    }

    private static void processSchemaOptions(SchemaOption[] schemaOptions, ObjectNode schema) {
        if (Stream.of(schemaOptions).noneMatch(option -> option == SchemaOption.ALLOW_ADDITIONAL_PROPERTIES_BY_DEFAULT)) {
            schema.put("additionalProperties", false);
        }
        if (Stream.of(schemaOptions).anyMatch(option -> option == SchemaOption.UPPER_CASE_TYPE_VALUES)) {
            CloudtJsonSchemaGenerator.convertTypeValuesToUpperCase(schema);
        }
    }

    private static boolean isMethodParameterRequired(Method method, int index) {
        Parameter parameter = method.getParameters()[index];
        ToolParam toolParamAnnotation = parameter.getAnnotation(ToolParam.class);
        if (toolParamAnnotation != null) {
            return toolParamAnnotation.required();
        }
        JsonProperty propertyAnnotation = parameter.getAnnotation(JsonProperty.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.required();
        }
        Schema schemaAnnotation = parameter.getAnnotation(Schema.class);
        if (schemaAnnotation != null) {
            return schemaAnnotation.requiredMode() == Schema.RequiredMode.REQUIRED || schemaAnnotation.requiredMode() == Schema.RequiredMode.AUTO || schemaAnnotation.required();
        }
        Nullable nullableAnnotation = parameter.getAnnotation(Nullable.class);
        if (nullableAnnotation != null) {
            return false;
        }
        ApiModelProperty apiModelProperty = parameter.getAnnotation(ApiModelProperty.class);
        if (apiModelProperty != null) {
            return apiModelProperty.required();
        }
        NotNull notNullAnnotation = parameter.getAnnotation(NotNull.class);
        if (notNullAnnotation != null) {
            return true;
        }
        NotBlank notBlankAnnotation = parameter.getAnnotation(NotBlank.class);
        if (notBlankAnnotation != null) {
            return true;
        }
        NotEmpty notEmptyAnnotation = parameter.getAnnotation(NotEmpty.class);
        if (notEmptyAnnotation != null) {
            return true;
        }
        RequestParam requestParamAnnotation = parameter.getAnnotation(RequestParam.class);
        if (requestParamAnnotation != null) {
            return requestParamAnnotation.required();
        }
        return true;
    }

    @Nullable
    private static String getMethodParameterDescription(Method method, int index) {
        String parameterName;
        Parameter parameter = method.getParameters()[index];
        ToolParam toolParamAnnotation = parameter.getAnnotation(ToolParam.class);
        if (toolParamAnnotation != null && StringUtils.hasText((String)toolParamAnnotation.description())) {
            return toolParamAnnotation.description();
        }
        JsonPropertyDescription jacksonAnnotation = parameter.getAnnotation(JsonPropertyDescription.class);
        if (jacksonAnnotation != null && StringUtils.hasText((String)jacksonAnnotation.value())) {
            return jacksonAnnotation.value();
        }
        Schema schemaAnnotation = parameter.getAnnotation(Schema.class);
        if (schemaAnnotation != null && StringUtils.hasText((String)schemaAnnotation.description())) {
            return schemaAnnotation.description();
        }
        ApiModelProperty apiModelPropertyAnnotation = parameter.getAnnotation(ApiModelProperty.class);
        if (apiModelPropertyAnnotation != null && StringUtils.hasText((String)apiModelPropertyAnnotation.value())) {
            return apiModelPropertyAnnotation.value();
        }
        ApiImplicitParam apiImplicitParamAnnotation = method.getAnnotation(ApiImplicitParam.class);
        if (apiImplicitParamAnnotation != null && (parameterName = CloudtJsonSchemaGenerator.getMethodParameterName(parameter)).equals(apiImplicitParamAnnotation.name())) {
            return apiImplicitParamAnnotation.value();
        }
        ApiImplicitParams apiImplicitParamsAnnotation = method.getAnnotation(ApiImplicitParams.class);
        if (apiImplicitParamsAnnotation != null && ArrayUtil.isNotEmpty((Object[])apiImplicitParamsAnnotation.value())) {
            String parameterName2 = CloudtJsonSchemaGenerator.getMethodParameterName(parameter);
            for (ApiImplicitParam apiImplicitParam : apiImplicitParamsAnnotation.value()) {
                if (!parameterName2.equals(apiImplicitParam.name())) continue;
                return apiImplicitParam.value();
            }
        }
        return null;
    }

    public static void convertTypeValuesToUpperCase(ObjectNode node) {
        if (node.isObject()) {
            node.fields().forEachRemaining(entry -> {
                JsonNode value = (JsonNode)entry.getValue();
                if (value.isObject()) {
                    CloudtJsonSchemaGenerator.convertTypeValuesToUpperCase((ObjectNode)value);
                } else if (value.isArray()) {
                    value.elements().forEachRemaining(element -> {
                        if (element.isObject() || element.isArray()) {
                            CloudtJsonSchemaGenerator.convertTypeValuesToUpperCase((ObjectNode)element);
                        }
                    });
                } else if (value.isTextual() && ((String)entry.getKey()).equals("type")) {
                    String oldValue = node.get("type").asText();
                    node.put("type", oldValue.toUpperCase());
                }
            });
        } else if (node.isArray()) {
            node.elements().forEachRemaining(element -> {
                if (element.isObject() || element.isArray()) {
                    CloudtJsonSchemaGenerator.convertTypeValuesToUpperCase((ObjectNode)element);
                }
            });
        }
    }

    static {
        JacksonModule jacksonModule = new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED});
        Swagger2Module openApiModule = new Swagger2Module();
        CloudtSpringAiSchemaModule springAiSchemaModule = new CloudtSpringAiSchemaModule(new CloudtSpringAiSchemaModule.Option[0]);
        SchemaGeneratorConfigBuilder schemaGeneratorConfigBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((Module)jacksonModule).with((Module)openApiModule).with((Module)springAiSchemaModule).with(Option.EXTRA_OPEN_API_FORMAT_VALUES, new Option[0]).with(Option.PLAIN_DEFINITION_KEYS, new Option[0]);
        SchemaGeneratorConfig typeSchemaGeneratorConfig = schemaGeneratorConfigBuilder.build();
        TYPE_SCHEMA_GENERATOR = new SchemaGenerator(typeSchemaGeneratorConfig);
        SchemaGeneratorConfig subtypeSchemaGeneratorConfig = schemaGeneratorConfigBuilder.without(Option.SCHEMA_VERSION_INDICATOR, new Option[0]).build();
        SUBTYPE_SCHEMA_GENERATOR = new SchemaGenerator(subtypeSchemaGeneratorConfig);
    }

    public static enum SchemaOption {
        ALLOW_ADDITIONAL_PROPERTIES_BY_DEFAULT,
        UPPER_CASE_TYPE_VALUES;

    }
}

