/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.tool.definition;

import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.util.ParsingUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public record DefaultToolDefinition(String name, String description, String inputSchema) implements ToolDefinition
{
    public DefaultToolDefinition {
        Assert.hasText((String)name, (String)"name cannot be null or empty");
        Assert.hasText((String)description, (String)"description cannot be null or empty");
        Assert.hasText((String)inputSchema, (String)"inputSchema cannot be null or empty");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String description;
        private String inputSchema;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder inputSchema(String inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public ToolDefinition build() {
            if (!StringUtils.hasText((String)this.description)) {
                Assert.hasText((String)this.name, (String)"toolName cannot be null or empty");
                this.description = ParsingUtils.reConcatenateCamelCase(this.name, " ");
            }
            return new DefaultToolDefinition(this.name, this.description, this.inputSchema);
        }
    }
}

