/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mcp.config.filter;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.auth.BearerTokenAuthenticationToken;
import com.elitescloud.boot.auth.client.config.security.configurer.filter.AbstractAuthorizationFilter;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.common.ParamIn;
import com.elitescloud.boot.mcp.config.CloudtMcpServerProperties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.AuthenticationException;

public class McpSessionIdAuthenticationFilter
extends AbstractAuthorizationFilter<BearerTokenAuthenticationToken> {
    private static final Logger logger = CloudtBootLoggerFactory.MCP.getLogger(McpSessionIdAuthenticationFilter.class);
    private final CloudtMcpServerProperties cloudtMcpServerProperties;

    public McpSessionIdAuthenticationFilter(AuthenticationManager authenticationManager, CloudtMcpServerProperties cloudtMcpServerProperties) {
        super(authenticationManager);
        this.cloudtMcpServerProperties = cloudtMcpServerProperties;
    }

    protected BearerTokenAuthenticationToken obtain(HttpServletRequest request) throws AuthenticationException {
        String sessionId = this.getSessionId(request);
        if (CharSequenceUtil.isBlank((CharSequence)sessionId)) {
            return null;
        }
        logger.info("MCP Session\uff1a{}", (Object)sessionId);
        return null;
    }

    protected String getSessionId(HttpServletRequest request) {
        String[] params;
        CloudtMcpServerProperties.Security props = this.cloudtMcpServerProperties.getSecurity();
        String ssePath = this.getParam(request, props.getSseParamName(), props.getSseParamIn());
        if (CharSequenceUtil.isBlank((CharSequence)ssePath)) {
            return null;
        }
        int paramsIndex = ssePath.lastIndexOf(63);
        if (paramsIndex < 0) {
            return null;
        }
        for (String param : params = ssePath.substring(paramsIndex + 1).split("&")) {
            String[] kv = param.split("=");
            if (!props.getSessionIdParamName().equals(kv[0]) && kv.length <= 1) continue;
            return kv[1];
        }
        return null;
    }

    protected String getParam(HttpServletRequest request, String paramName, ParamIn paramIn) {
        if (paramIn == null || CharSequenceUtil.isBlank((CharSequence)paramName)) {
            return null;
        }
        switch (paramIn) {
            case QUERY: 
            case FORM: {
                return request.getParameter(paramName);
            }
            case HEADER: {
                return request.getHeader(paramName);
            }
            case COOKIE: {
                Object[] cookies = request.getCookies();
                if (ArrayUtil.isEmpty((Object[])cookies)) {
                    return null;
                }
                for (Object cookie : cookies) {
                    if (!paramName.equalsIgnoreCase(cookie.getName())) continue;
                    return cookie.getValue();
                }
                break;
            }
        }
        throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u7684\u53c2\u6570\u4f4d\u7f6e\uff1a" + String.valueOf(paramIn));
    }
}

