/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mcp.common;

import com.elitescloud.boot.mcp.common.McpToolMethodInstance;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

public class McpToolHolder {
    private static final Map<String, McpToolMethodInstance> toolHandlers = new HashMap<String, McpToolMethodInstance>();

    public static void registerHandlerMethod(@NotBlank String toolName, @NotNull McpToolMethodInstance handlerMethod) {
        if (toolHandlers.containsKey(toolName)) {
            throw new RuntimeException("Mcp Tool\u540d\u79f0\u5df2\u5b58\u5728\uff1a{}" + toolName);
        }
        toolHandlers.put(toolName, handlerMethod);
    }

    public static boolean exists(@NotBlank String toolName) {
        return toolHandlers.containsKey(toolName);
    }

    public static McpToolMethodInstance getByMethod(@NotNull Method method) {
        for (McpToolMethodInstance value : toolHandlers.values()) {
            if (!value.getHandlerMethod().getMethod().equals(method)) continue;
            return value;
        }
        return null;
    }

    public static McpToolMethodInstance getByToolName(@NotBlank String toolName) {
        return toolHandlers.get(toolName);
    }

    public static Map<String, McpToolMethodInstance> getAll() {
        return Collections.unmodifiableMap(toolHandlers);
    }
}

