/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config;

import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.mq.common.MessageDuplicateStrategy;
import com.elitescloud.boot.mq.common.MessageQueueStorage;
import com.elitescloud.boot.mq.common.MessageRetryProvider;
import com.elitescloud.boot.mq.common.MessageRetryService;
import com.elitescloud.boot.mq.config.CloudtMqProperties;
import com.elitescloud.boot.mq.config.support.CloudtMessageChannel;
import com.elitescloud.boot.mq.config.support.DefaultMessageQueueTemplate;
import com.elitescloud.boot.mq.config.support.MessageQueueConsumerDelegate;
import com.elitescloud.boot.mq.config.support.MessageRetryServiceImpl;
import com.elitescloud.boot.mq.tenant.SpringCloudStreamTenantConfig;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;

@Import(value={SpringCloudStreamTenantConfig.class})
@EnableBinding(value={CloudtMessageChannel.class})
@ConditionalOnProperty(prefix="elitesland.mq", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={CloudtMqProperties.class})
public class CloudtMqAutoConfiguration {
    private final CloudtMqProperties mqProperties;

    public CloudtMqAutoConfiguration(CloudtMqProperties mqProperties) {
        this.mqProperties = mqProperties;
    }

    @Bean
    public MessageQueueTemplate messageQueueTemplateDefault(TaskExecutor taskExecutor, ObjectMapper objectMapper, RedisUtils redisUtils, List<MessageQueueStorage> queueStorageList, List<MessageDuplicateStrategy> duplicateStrategyList) {
        DefaultMessageQueueTemplate template = new DefaultMessageQueueTemplate(taskExecutor, objectMapper, this.mqProperties, redisUtils);
        template.setQueueStorageList(queueStorageList);
        template.setDuplicateStrategyList(duplicateStrategyList);
        return template;
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.mq", name={"allow-consume"}, havingValue="true", matchIfMissing=true)
    public MessageQueueConsumerDelegate messageQueueConsumerDelegate(TaskExecutor taskExecutor, ObjectMapper objectMapper, List<MessageQueueStorage> queueStorageList) {
        MessageQueueConsumerDelegate consumerDelegate = new MessageQueueConsumerDelegate(objectMapper, taskExecutor);
        consumerDelegate.setQueueStorageList(queueStorageList);
        return consumerDelegate;
    }

    @Bean
    @ConditionalOnBean(value={MessageRetryProvider.class})
    @ConditionalOnProperty(prefix="elitesland.mq", name={"support-retry"}, havingValue="true")
    public MessageRetryService messageRetryService(ObjectMapper objectMapper, RedissonClient redissonClient, MessageRetryProvider messageRetryProvider, TenantDataIsolateProvider tenantDataIsolateProvider) {
        return new MessageRetryServiceImpl(objectMapper, redissonClient, messageRetryProvider, this.mqProperties, tenantDataIsolateProvider);
    }
}

