/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

abstract class AbstractMessageQueueDelegate {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageQueueDelegate.class);
    protected final ObjectMapper objectMapper;
    private Map<String, List<MessageQueueListenerWrapper>> listenerMap;

    public AbstractMessageQueueDelegate(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected Map<String, List<MessageQueueListenerWrapper>> getListenerMap() {
        if (this.listenerMap == null) {
            this.listenerMap = this.initMessageQueueListener(SpringContextHolder.getObjectProvider(MessageQueueListener.class).stream().collect(Collectors.toList()));
        }
        return this.listenerMap;
    }

    protected <T extends Serializable> void publishMqMessage(@NotNull MessageChannel messageChannel, @NotBlank String channel, @NotBlank String messageId, @NotNull T payload) {
        Assert.notBlank((CharSequence)messageId, (String)"\u6d88\u606fID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(payload, (String)"\u53d1\u5e03\u6d88\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        log.info("\u53d1\u5e03\u6d88\u606f\uff1a{}, {}", (Object)channel, (Object)messageId);
        String payloadStr = null;
        if (payload instanceof String) {
            payloadStr = (String)((Object)payload);
        } else {
            try {
                payloadStr = this.objectMapper.writeValueAsString(payload);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(channel + "\u5e8f\u5217\u5316\u6d88\u606f\u4f53\u5f02\u5e38\uff1a", e);
            }
        }
        Message message = MessageBuilder.withPayload((Object)payloadStr).setHeader("cloudt_message_original_channel", (Object)channel).setHeader("cloudt_message_id", (Object)messageId).build();
        messageChannel.send(message);
    }

    protected String generateMessageId() {
        return UUID.fastUUID().toString(true) + ":" + RandomUtil.randomString((int)6);
    }

    private Map<String, List<MessageQueueListenerWrapper>> initMessageQueueListener(List<MessageQueueListener> listenerList) {
        if (CollUtil.isEmpty(listenerList)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<MessageQueueListenerWrapper>> initListenerMap = new HashMap<String, List<MessageQueueListenerWrapper>>();
        for (MessageQueueListener listener : listenerList) {
            Assert.notEmpty((Object[])listener.channels(), (String)(listener.getClass().getName() + "\u4e2d\u6e20\u9053\u672a\u914d\u7f6e"), (Object[])new Object[0]);
            for (String channel : listener.channels()) {
                initListenerMap.computeIfAbsent(channel, c -> new ArrayList(8)).add(new MessageQueueListenerWrapper(listener));
            }
        }
        return initListenerMap;
    }

    static class MessageQueueListenerWrapper {
        private final MessageQueueListener<?> messageQueueListener;
        private Class<?> messageType;

        public MessageQueueListenerWrapper(MessageQueueListener<?> messageQueueListener) {
            this.messageQueueListener = messageQueueListener;
            this.init();
        }

        public MessageQueueListener getMessageQueueListener() {
            return this.messageQueueListener;
        }

        public Class<?> getMessageType() {
            return this.messageType;
        }

        private void init() {
            this.messageType = this.obtainMessageType();
        }

        private Class<?> obtainMessageType() {
            Type temp;
            Type[] typeArguments;
            Type[] genericInterfaces = this.messageQueueListener.getClass().getGenericInterfaces();
            if (genericInterfaces.length > 0 && genericInterfaces[0] instanceof ParameterizedType && (typeArguments = ((ParameterizedType)genericInterfaces[0]).getActualTypeArguments()).length > 0 && (temp = typeArguments[0]) instanceof Class) {
                return (Class)temp;
            }
            throw new IllegalStateException(this.messageQueueListener.getClass().getName() + "\u7684\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a\u6216\u4e0d\u652f\u6301");
        }
    }
}

