/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.mq.common.model.RetryMessageDTO;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class RetryMessage
implements Delayed {
    private final RetryMessageDTO retryMessageDTO;
    private final LocalDateTime sendTime;

    public RetryMessage(RetryMessageDTO retryMessageDTO) {
        this.retryMessageDTO = retryMessageDTO;
        this.sendTime = retryMessageDTO.getSendTimeNext();
        Assert.notNull((Object)retryMessageDTO.getSendTimeNext(), (String)"\u4e0b\u6b21\u53d1\u9001\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    public long getDelay(@NotNull TimeUnit unit) {
        return unit.convert(Duration.between(LocalDateTime.now(), this.sendTime));
    }

    @Override
    public int compareTo(@NotNull Delayed o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof RetryMessage) {
            RetryMessage msg = (RetryMessage)o;
            return this.getSendTime().compareTo(msg.getSendTime());
        }
        return 0;
    }

    public RetryMessageDTO getRetryMessageDTO() {
        return this.retryMessageDTO;
    }

    public LocalDateTime getSendTime() {
        return this.sendTime;
    }
}

