/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.boot.mq.common.BaseMessage;
import com.elitescloud.boot.util.JSONUtil;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.MutableMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class MessageCommonSupport {
    private static final Logger log = LoggerFactory.getLogger(MessageCommonSupport.class);
    private Map<String, List<MessageQueueListenerWrapper>> listenerMap;

    Map<String, List<MessageQueueListenerWrapper>> getListenerMap() {
        if (this.listenerMap == null) {
            this.listenerMap = this.initMessageQueueListener(SpringContextHolder.getObjectProvider(MessageQueueListener.class).stream().collect(Collectors.toList()));
        }
        return this.listenerMap;
    }

    <T extends Serializable> void publishMqMessage(@NotNull MessageChannel messageChannel, @NotBlank String channel, @NotBlank String messageId, @NotNull T payload) {
        Assert.notBlank((CharSequence)messageId, (String)"\u6d88\u606fID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(payload, (String)"\u53d1\u5e03\u6d88\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        log.info("\u53d1\u5e03\u6d88\u606f\uff1a{}, {}", (Object)channel, (Object)messageId);
        String payloadStr = null;
        payloadStr = payload instanceof String ? (String)((Object)payload) : JSONUtil.toJsonString(payload, (boolean)true, () -> channel + "\u5e8f\u5217\u5316\u6d88\u606f\u4f53\u5f02\u5e38");
        AbstractIntegrationMessageBuilder messageBuilder = MutableMessageBuilder.withPayload((Object)payloadStr).setHeader("cloudt_message_original_channel", (Object)channel).setHeader("cloudt_message_id", (Object)messageId).setHeader("KEYS", (Object)this.buildMessageKeys(payload, messageId));
        Message message = messageBuilder.build();
        messageChannel.send(message);
    }

    <T extends Serializable> String buildMessageKeys(T payload, String messageId) {
        Object businessKey;
        ArrayList<String> keys = new ArrayList<String>(4);
        keys.add(messageId);
        if (payload instanceof BaseMessage) {
            String businessKey2 = ((BaseMessage)payload).getBusinessKey();
            if (CharSequenceUtil.isNotBlank((CharSequence)businessKey2)) {
                keys.add(businessKey2);
            }
        } else if (payload instanceof Map && (businessKey = ((Map)((Object)payload)).get("businessKey")) instanceof String && CharSequenceUtil.isNotBlank((CharSequence)((String)businessKey))) {
            keys.add((String)businessKey);
        }
        return String.join((CharSequence)" ", keys);
    }

    String generateMessageId() {
        return UUID.fastUUID().toString(true) + ":" + RandomUtil.randomString((int)6);
    }

    String messageToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSONUtil.toJsonString((Object)obj, (boolean)true, () -> "\u6d88\u606f\u5e8f\u5217\u5316\u5f02\u5e38");
    }

    <T> T readMessage(String message, Class<T> clazz) {
        return (T)JSONUtil.json2Obj((String)message, clazz, (boolean)true, () -> "\u6d88\u606f\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
    }

    private Map<String, List<MessageQueueListenerWrapper>> initMessageQueueListener(List<MessageQueueListener> listenerList) {
        if (CollUtil.isEmpty(listenerList)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<MessageQueueListenerWrapper>> initListenerMap = new HashMap<String, List<MessageQueueListenerWrapper>>();
        for (MessageQueueListener listener : listenerList) {
            Assert.notEmpty((Object[])listener.channels(), (String)(listener.getClass().getName() + "\u4e2d\u6e20\u9053\u672a\u914d\u7f6e"), (Object[])new Object[0]);
            for (String channel : listener.channels()) {
                initListenerMap.computeIfAbsent(channel, c -> new ArrayList(8)).add(new MessageQueueListenerWrapper(listener));
            }
        }
        return initListenerMap;
    }

    static class MessageQueueListenerWrapper {
        private final MessageQueueListener<?> messageQueueListener;
        private Class<?> messageType;

        public MessageQueueListenerWrapper(MessageQueueListener<?> messageQueueListener) {
            this.messageQueueListener = messageQueueListener;
            this.init();
        }

        public MessageQueueListener getMessageQueueListener() {
            return this.messageQueueListener;
        }

        public Class<?> getMessageType() {
            return this.messageType;
        }

        private void init() {
            this.messageType = this.obtainMessageType();
        }

        private Class<?> obtainMessageType() {
            Type temp;
            Type[] typeArguments;
            Type[] genericInterfaces = this.messageQueueListener.getClass().getGenericInterfaces();
            if (genericInterfaces.length > 0 && genericInterfaces[0] instanceof ParameterizedType && (typeArguments = ((ParameterizedType)genericInterfaces[0]).getActualTypeArguments()).length > 0 && (temp = typeArguments[0]) instanceof Class) {
                return (Class)temp;
            }
            throw new IllegalStateException(this.messageQueueListener.getClass().getName() + "\u7684\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a\u6216\u4e0d\u652f\u6301");
        }
    }
}

