/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.mq.common.MessageQueueStorage;
import com.elitescloud.boot.mq.config.support.MessageCommonSupport;
import com.elitescloud.boot.util.ExceptionsUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.core.task.TaskExecutor;
import org.springframework.messaging.Message;

public class MessageQueueConsumerDelegate {
    private static final Logger log = LoggerFactory.getLogger(MessageQueueConsumerDelegate.class);
    private final MessageCommonSupport messageCommonSupport;
    private final TaskExecutor taskExecutor;
    private List<MessageQueueStorage> queueStorageList = Collections.emptyList();

    public MessageQueueConsumerDelegate(MessageCommonSupport messageCommonSupport, TaskExecutor taskExecutor) {
        this.messageCommonSupport = messageCommonSupport;
        this.taskExecutor = taskExecutor;
    }

    @StreamListener(value="cloudt_message_delegate_channel_input")
    public void consumer(Message<String> message) {
        String originalChannel = (String)message.getHeaders().get((Object)"cloudt_message_original_channel", String.class);
        if (CharSequenceUtil.isBlank((CharSequence)originalChannel)) {
            log.info("\u672a\u627e\u5230\u6d88\u606f\u7684channel\uff0c\u5ffd\u7565\u6d88\u606f");
            return;
        }
        if (CharSequenceUtil.isBlank((CharSequence)((CharSequence)message.getPayload()))) {
            log.info("\u6d88\u606f\u4f53\u4e3a\u7a7a\uff0c\u5ffd\u7565\u6d88\u606f");
            return;
        }
        List listeners = this.messageCommonSupport.getListenerMap().getOrDefault(originalChannel, Collections.emptyList());
        if (listeners.isEmpty()) {
            return;
        }
        String messageId = (String)message.getHeaders().get((Object)"cloudt_message_id", String.class);
        Throwable exp = null;
        for (MessageCommonSupport.MessageQueueListenerWrapper listener : listeners) {
            log.info("{}\u5f00\u59cb\u6d88\u8d39\u6d88\u606f\uff1a{}", (Object)listener.getClass().getName(), (Object)messageId);
            try {
                Object msg = this.messageCommonSupport.readMessage((String)message.getPayload(), listener.getMessageType());
                listener.getMessageQueueListener().onConsume(originalChannel, (Serializable)msg);
                exp = null;
            }
            catch (Throwable e) {
                log.error("\u6d88\u8d39\u8005{}\u6d88\u8d39\u6d88\u606f{}\u5f02\u5e38\uff1a", new Object[]{listener.getMessageQueueListener().getClass().getName(), message.getPayload(), e});
                exp = e;
            }
        }
        this.updateConsumeResult(messageId, exp);
    }

    public void setQueueStorageList(List<MessageQueueStorage> queueStorageList) {
        this.queueStorageList = (List)ObjectUtil.defaultIfNull(queueStorageList, Collections.emptyList());
    }

    private void updateConsumeResult(String messageId, Throwable exp) {
        if (CollUtil.isEmpty(this.queueStorageList)) {
            return;
        }
        if (CharSequenceUtil.isBlank((CharSequence)messageId)) {
            log.warn("\u6d88\u606fID\u4e3a\u7a7a\uff0c\u5ffd\u7565\u66f4\u65b0\u6d88\u8d39\u7ed3\u679c");
            return;
        }
        CompletableFuture.runAsync(() -> {
            boolean success = exp == null;
            String expMsg = exp == null ? null : ExceptionsUtil.stackTraceAllToString((Throwable)exp);
            for (MessageQueueStorage storage : this.queueStorageList) {
                storage.updateConsumeResult(messageId, success, expMsg);
            }
        }, (Executor)this.taskExecutor).whenComplete((res, e) -> {
            if (e != null) {
                log.error("\u66f4\u65b0\u6d88\u8d39\u7ed3\u679c\u5f02\u5e38\uff1a{}", (Object)messageId, e);
            }
        });
    }
}

