/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.tenant;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.mq.tenant.TenantMessagingInputInterceptor;
import com.elitescloud.boot.mq.tenant.TenantMessagingOutputInterceptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.stream.config.ChannelsEndpointAutoConfiguration;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.support.ChannelInterceptor;

@ConditionalOnTenant
@ConditionalOnClass(value={ChannelsEndpointAutoConfiguration.class})
public class SpringCloudStreamTenantConfig {
    private static final Logger log = LogManager.getLogger(SpringCloudStreamTenantConfig.class);

    @Bean
    public BeanPostProcessor springCloudStreamChannelInterceptorTenant() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return super.postProcessBeforeInitialization(bean, beanName);
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof DirectWithAttributesChannel) {
                    DirectWithAttributesChannel channel = (DirectWithAttributesChannel)bean;
                    String type = (String)channel.getAttribute("type");
                    if ("input".equals(type)) {
                        channel.addInterceptor(0, (ChannelInterceptor)new TenantMessagingInputInterceptor());
                    } else if ("output".equals(type)) {
                        channel.addInterceptor(0, (ChannelInterceptor)new TenantMessagingOutputInterceptor());
                    } else {
                        log.error("\u672a\u77e5MessageChannel\u7c7b\u578b\uff1a{}\uff0c{}", (Object)beanName, (Object)type);
                    }
                }
                return super.postProcessAfterInitialization(bean, beanName);
            }
        };
    }
}

