/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config;

import cn.hutool.core.text.CharSequenceUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.lang.NonNull;

class CloudtMqEnvironmentListener
implements SmartApplicationListener,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(CloudtMqEnvironmentListener.class);

    CloudtMqEnvironmentListener() {
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType.isAssignableFrom(ApplicationContextInitializedEvent.class);
    }

    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        if (event instanceof ApplicationContextInitializedEvent) {
            ConfigurableEnvironment env = ((ApplicationContextInitializedEvent)event).getApplicationContext().getEnvironment();
            if (!(env instanceof StandardEnvironment)) {
                return;
            }
            StandardEnvironment environment = (StandardEnvironment)((ApplicationContextInitializedEvent)event).getApplicationContext().getEnvironment();
            PropertySource propertySource = environment.getPropertySources().get("defaultProperties");
            if (propertySource == null) {
                throw new IllegalStateException("\u7f3a\u5c11\u9ed8\u8ba4PropertySource");
            }
            Map defaultProperties = (Map)propertySource.getSource();
            this.createDefaultProperties((ConfigurableEnvironment)environment, defaultProperties);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private Map<String, Object> createDefaultProperties(ConfigurableEnvironment environment, Map<String, Object> defaultProperties) {
        String topicPrefix = environment.getProperty("elitesland.mq.topic-prefix");
        Object topic = CharSequenceUtil.isBlank((CharSequence)topicPrefix) ? "cloudt_message_delegate_channel" : topicPrefix + "cloudt_message_delegate_channel";
        defaultProperties.put("spring.cloud.stream.bindings.cloudt_message_delegate_channel_output.destination", topic);
        defaultProperties.put("spring.cloud.stream.bindings.cloudt_message_delegate_channel_input.destination", topic);
        String consumerGroup = environment.getProperty("elitesland.mq.consumer-group");
        if (CharSequenceUtil.isBlank((CharSequence)consumerGroup)) {
            consumerGroup = this.createConsumerGroup(environment);
        }
        log.info("CloudtMq: group is {}, topic is {}", (Object)consumerGroup, topic);
        defaultProperties.put("spring.cloud.stream.bindings.cloudt_message_delegate_channel_input.group", consumerGroup);
        return defaultProperties;
    }

    private String createConsumerGroup(ConfigurableEnvironment environment) {
        String appName = environment.getProperty("spring.application.name");
        if (CharSequenceUtil.isBlank((CharSequence)appName)) {
            log.error("\u5e94\u7528\u540d\u79f0\u4e3a\u7a7a\uff1aspring.application.name");
            appName = "unknown";
        }
        return "cloudt_message_consumer_" + appName;
    }
}

