/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config;

import com.alibaba.cloud.stream.binder.rocketmq.config.RocketMQComponent4BinderAutoConfiguration;
import com.elitescloud.boot.mq.config.CloudtMqProperties;
import com.elitescloud.boot.mq.config.support.CloudtRocketMQTemplate;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.spring.autoconfigure.RocketMQAutoConfiguration;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={RocketMQAutoConfiguration.class, RocketMQComponent4BinderAutoConfiguration.class})
@AutoConfigureBefore(value={RocketMQAutoConfiguration.class, RocketMQComponent4BinderAutoConfiguration.class})
public class CloudtRocketMqAutoConfiguration {
    private final CloudtMqProperties properties;

    public CloudtRocketMqAutoConfiguration(CloudtMqProperties properties) {
        this.properties = properties;
    }

    @Bean(destroyMethod="destroy")
    public RocketMQTemplate customRocketMQTemplate(@Autowired(required=false) DefaultMQProducer mqProducer, ObjectMapper rocketMQMessageObjectMapper) {
        CloudtRocketMQTemplate rocketMQTemplate = new CloudtRocketMQTemplate(mqProducer, this.properties);
        boolean enabled = true;
        if (mqProducer == null) {
            enabled = false;
            mqProducer = new DefaultMQProducer();
        }
        rocketMQTemplate.setProducer(mqProducer);
        rocketMQTemplate.setObjectMapper(rocketMQMessageObjectMapper);
        return rocketMQTemplate;
    }
}

