/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support;

import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class CloudtMessagingOutputInterceptor
implements ChannelInterceptor {
    private static final Logger log = LogManager.getLogger(CloudtMessagingOutputInterceptor.class);
    private final TenantClientProvider tenantClientProvider;

    public CloudtMessagingOutputInterceptor(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        Long tenantId = TenantConstant.DEFAULT_TENANT_ID;
        if (this.tenantClientProvider.enabledTenant()) {
            SysTenantDTO tenant = TenantClient.getSessionTenant();
            if (tenant == null) {
                return message;
            }
            tenantId = tenant.getId();
        }
        MessageHeaderAccessor headerAccessor = MessageHeaderAccessor.getMutableAccessor(message);
        headerAccessor.setHeaderIfAbsent("current_tenant_id", (Object)tenantId.toString());
        return MessageBuilder.withPayload((Object)message.getPayload()).copyHeaders((Map)headerAccessor.getMessageHeaders()).build();
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        if (ex == null) {
            log.info("MQ\u6d88\u606f\u3010{}\u3011\u5df2\u53d1\u9001\uff0c\u6240\u5c5e\u79df\u6237{}\uff01", new Supplier[]{() -> message.getHeaders().getId(), () -> message.getHeaders().get((Object)"current_tenant_id")});
            return;
        }
        log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a", (Throwable)ex);
    }
}

