/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support.queue.messagechannel;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.mq.common.BaseMessage;
import com.elitescloud.boot.mq.common.MessageQueueStorage;
import com.elitescloud.boot.mq.config.CloudtMqProperties;
import com.elitescloud.boot.mq.config.support.queue.AbstractMqProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.MutableMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class MessageChannelMqProvider
extends AbstractMqProvider {
    private static final Logger logger = LoggerFactory.getLogger(MessageChannelMqProvider.class);
    private MessageChannel messageChannel;

    public MessageChannelMqProvider(CloudtMqProperties properties, List<MessageQueueStorage> queueStorageList) {
        super(properties, queueStorageList);
    }

    @Override
    protected void sendMessage(String channel, String messageId, String payload) {
        AbstractIntegrationMessageBuilder messageBuilder = MutableMessageBuilder.withPayload((Object)payload).setHeader("cloudt_message_original_channel", (Object)channel).setHeader("cloudt_message_id", (Object)messageId).setHeader("KEYS", (Object)this.obtainMessageKeys(payload, messageId));
        Message message = messageBuilder.build();
        this.messageChannel.send(message);
    }

    @Autowired
    @Output(value="cloudt_message_delegate_channel_output")
    public void setMessageChannel(MessageChannel messageChannel) {
        this.messageChannel = messageChannel;
    }

    @StreamListener(value="cloudt_message_delegate_channel_input")
    public void consumer(Message<String> message) {
        String originalChannel = (String)message.getHeaders().get((Object)"cloudt_message_original_channel", String.class);
        String messageId = (String)message.getHeaders().get((Object)"cloudt_message_id", String.class);
        super.consumeMessage(originalChannel, messageId, (String)message.getPayload());
    }

    protected <T extends Serializable> String obtainMessageKeys(T payload, String messageId) {
        Object businessKey;
        ArrayList<String> keys = new ArrayList<String>(4);
        keys.add(messageId);
        if (payload instanceof BaseMessage) {
            String businessKey2 = ((BaseMessage)payload).getBusinessKey();
            if (CharSequenceUtil.isNotBlank((CharSequence)businessKey2)) {
                keys.add(businessKey2);
            }
        } else if (payload instanceof Map && (businessKey = ((Map)((Object)payload)).get("businessKey")) instanceof String && CharSequenceUtil.isNotBlank((CharSequence)((String)businessKey))) {
            keys.add((String)businessKey);
        }
        return String.join((CharSequence)" ", keys);
    }
}

