/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.base.AbstractLogTraceHandler;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.context.ExecutorContextHolder;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;

public class CloudtMessagingInputInterceptor
extends AbstractLogTraceHandler
implements ChannelInterceptor {
    private static final Logger log = LogManager.getLogger(CloudtMessagingInputInterceptor.class);
    private final TenantClientProvider tenantClientProvider;

    public CloudtMessagingInputInterceptor(String applicationName, TenantClientProvider tenantClientProvider) {
        super(applicationName);
        this.tenantClientProvider = tenantClientProvider;
    }

    public Message<?> preSend(@NonNull Message<?> message, @NonNull MessageChannel channel) {
        super.putTraceId();
        Long tenantId = this.obtainTenantId(message);
        if (tenantId != null) {
            SysTenantDTO tenant = this.tenantClientProvider.getTenant(tenantId);
            if (tenant == null) {
                log.error("MQ\u6d88\u606f\u3010{}\u3011\u5904\u7406\u5931\u8d25\uff0c\u672a\u627e\u5230\u79df\u6237\uff1a{}", (Object)this.obtainMessageId(message), (Object)tenantId);
                return null;
            }
            TenantContextHolder.setCurrentTenant((SysTenantDTO)tenant);
        }
        ExecutorContextHolder.create((ExecutorContextHolder.Source)ExecutorContextHolder.Source.MQ, null, (boolean)false);
        log.debug("MQ\u6d88\u606f\u3010{}\u3011\u6d88\u8d39...", (Object)tenantId);
        return message;
    }

    public void afterSendCompletion(@NonNull Message<?> message, @NonNull MessageChannel channel, boolean sent, Exception ex) {
        super.clearTraceId();
        Long tenantId = this.obtainTenantId(message);
        if (tenantId != null) {
            TenantContextHolder.clearCurrentTenant();
        }
        ExecutorContextHolder.clear();
        if (ex == null) {
            log.debug("MQ\u6d88\u606f\u3010{}\u3011\u63a5\u6536\u5904\u7406\u6210\u529f\uff0c\u6240\u5c5e\u79df\u6237{}", new Supplier[]{() -> this.obtainMessageId(message), () -> tenantId});
            return;
        }
        log.error("MQ\u6d88\u606f\u3010" + this.obtainMessageId(message) + "\u3011\u63a5\u6536\u5904\u7406\u5931\u8d25\uff0c\u6240\u5c5e\u79df\u6237" + tenantId, (Throwable)ex);
    }

    private String obtainMessageId(Message<?> message) {
        Object messageId = message.getHeaders().get((Object)"cloudt_message_id");
        if (messageId != null) {
            return messageId.toString();
        }
        return ((Serializable)ObjectUtil.defaultIfNull((Object)message.getHeaders().getId(), (Object)"")).toString();
    }

    private Long obtainTenantId(Message<?> message) {
        if (!this.tenantClientProvider.enabledTenant()) {
            return null;
        }
        Object tenantId = message.getHeaders().get((Object)"current_tenant_id");
        if (tenantId == null || TenantConstant.DEFAULT_TENANT_ID.toString().equals(tenantId.toString())) {
            return null;
        }
        try {
            return tenantId instanceof Long ? (Long)tenantId : Long.parseLong(tenantId.toString());
        }
        catch (NumberFormatException e) {
            log.error("\u79df\u6237ID\uff1a{}", tenantId, (Object)e);
            throw new IllegalStateException("\u79df\u6237ID\u89e3\u6790\u5f02\u5e38\uff1a", e);
        }
    }
}

