/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config;

import com.elitescloud.boot.mq.config.support.CloudtMessagingInputInterceptor;
import com.elitescloud.boot.mq.config.support.CloudtMessagingOutputInterceptor;
import com.elitescloud.boot.mq.config.support.CustomPublishSubscribeErrorChannel;
import com.elitescloud.boot.provider.TenantClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.stream.config.ChannelsEndpointAutoConfiguration;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.support.ChannelInterceptor;

@ConditionalOnClass(value={ChannelsEndpointAutoConfiguration.class})
public class CloudtSpringCloudStreamAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CloudtSpringCloudStreamAutoConfiguration.class);

    @Bean
    public BeanPostProcessor springCloudStreamChannelInterceptorTenant(final @Value(value="${spring.application.name:#{'unknown'}}") String applicationName, final TenantClientProvider tenantClientProvider) {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return super.postProcessBeforeInitialization(bean, beanName);
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof DirectWithAttributesChannel) {
                    DirectWithAttributesChannel channel = (DirectWithAttributesChannel)bean;
                    String type = (String)channel.getAttribute("type");
                    if ("input".equals(type)) {
                        channel.addInterceptor(0, (ChannelInterceptor)new CloudtMessagingInputInterceptor(applicationName, tenantClientProvider));
                    } else if ("output".equals(type)) {
                        channel.addInterceptor(0, (ChannelInterceptor)new CloudtMessagingOutputInterceptor(tenantClientProvider));
                    } else {
                        log.error("\u672a\u77e5MessageChannel\u7c7b\u578b\uff1a{}\uff0c{}", (Object)beanName, (Object)type);
                    }
                }
                return super.postProcessAfterInitialization(bean, beanName);
            }
        };
    }

    @Bean(value={"errorChannel"})
    public CustomPublishSubscribeErrorChannel customErrorChannel() {
        return new CustomPublishSubscribeErrorChannel();
    }
}

