/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support;

import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.mq.common.MessageRetryProvider;
import com.elitescloud.boot.mq.common.MessageRetryService;
import com.elitescloud.boot.mq.common.model.RetryMessageDTO;
import com.elitescloud.boot.mq.config.CloudtMqProperties;
import com.elitescloud.boot.mq.config.support.queue.MqProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.task.retry.AbstractRetryService;
import com.elitescloud.boot.task.retry.RetryTaskProvider;
import com.elitescloud.boot.util.JSONUtil;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRetryServiceImpl
extends AbstractRetryService<RetryMessageDTO>
implements MessageRetryService {
    private static final Logger log = LoggerFactory.getLogger(MessageRetryServiceImpl.class);
    private final MqProvider mqProvider;
    private final CloudtMqProperties mqProperties;

    public MessageRetryServiceImpl(MqProvider mqProvider, MessageRetryProvider messageRetryProvider, CloudtMqProperties mqProperties, TenantDataIsolateProvider tenantDataIsolateProvider) {
        super((RetryTaskProvider)messageRetryProvider, tenantDataIsolateProvider);
        this.mqProvider = mqProvider;
        this.mqProperties = mqProperties;
    }

    @Override
    public String generateMessageId() {
        return this.mqProvider.generateMessageId();
    }

    protected boolean supportRetry() {
        return Boolean.TRUE.equals(this.mqProperties.getSupportRetry());
    }

    protected int retryTimes() {
        return (Integer)ObjUtil.defaultIfNull((Object)this.mqProperties.getRetryTimes(), (Object)0);
    }

    protected List<Duration> retryIntervals() {
        return this.mqProperties.getRetryIntervals();
    }

    protected void executeTask(RetryMessageDTO task) {
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            HashMap message = (HashMap)JSONUtil.json2Obj((String)task.getMessageContent());
            this.mqProvider.publishMessage(task.getChannel(), task.getTaskId(), message == null ? task.getMessageContent() : message);
            return null;
        }, task.getSysTenantId());
    }
}

