/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support.storage;

import com.elitescloud.boot.mq.common.BaseMessage;
import com.elitescloud.boot.mq.common.MessageQueueStorage;
import com.elitescloud.boot.mq.common.model.StoreMessageDTO;
import com.elitescloud.boot.mq.config.support.queue.MqProvider;
import com.elitescloud.boot.support.app.CloudtAppHolder;
import java.io.Serializable;

public class MqMessageQueueStorage
implements MessageQueueStorage {
    public static final String CHANNEL = "cloudtMqLog";
    private final MqProvider mqProvider;

    public MqMessageQueueStorage(MqProvider mqProvider) {
        this.mqProvider = mqProvider;
    }

    @Override
    public void saveMessage(StoreMessageDTO messageDTO) {
        String messageRecordId = MqMessageQueueStorage.buildMessageKey(messageDTO.getMessageId());
        this.mqProvider.publishMessage(CHANNEL, messageRecordId, MessageLog.ofInitRecord(messageRecordId, messageDTO));
    }

    @Override
    public void updateSendResult(String messageId, boolean success, String failReason) {
        String messageRecordId = MqMessageQueueStorage.buildMessageKey(messageId);
        this.mqProvider.publishMessage(CHANNEL, messageRecordId, MessageLog.ofSendResult(messageRecordId, messageId, success, failReason));
    }

    @Override
    public void updateConsumeResult(String messageId, boolean success, String failReason, long cost) {
        String messageRecordId = MqMessageQueueStorage.buildMessageKey(messageId);
        this.mqProvider.publishMessage(CHANNEL, messageRecordId, MessageLog.ofConsumeResult(messageRecordId, messageId, success, failReason, cost));
    }

    private static String buildMessageKey(String messageId) {
        return "cloudtLog-" + messageId;
    }

    public static class MessageLog
    extends BaseMessage {
        private static final long serialVersionUID = -9143123412342027448L;
        private String messageRecordId;
        private RecordType recordType;
        private StoreMessageDTO message;
        private SendResult sendResult;
        private ConsumeResult consumeResult;

        @Override
        public String getBusinessKey() {
            return this.messageRecordId;
        }

        public static MessageLog ofInitRecord(String messageRecordId, StoreMessageDTO message) {
            MessageLog messageLog = new MessageLog();
            messageLog.setMessageRecordId(messageRecordId);
            messageLog.setRecordType(RecordType.INIT);
            messageLog.setMessage(message);
            return messageLog;
        }

        public static MessageLog ofSendResult(String messageRecordId, String messageId, Boolean success, String failReason) {
            MessageLog messageLog = new MessageLog();
            messageLog.setMessageRecordId(messageRecordId);
            messageLog.setRecordType(RecordType.UPDATE_SEND_RESULT);
            messageLog.setSendResult(new SendResult(messageId, success, failReason));
            return messageLog;
        }

        public static MessageLog ofConsumeResult(String messageRecordId, String messageId, Boolean success, String failReason, Long cost) {
            MessageLog messageLog = new MessageLog();
            messageLog.setMessageRecordId(messageRecordId);
            messageLog.setRecordType(RecordType.UPDATE_CONSUME_RESULT);
            messageLog.setConsumeResult(new ConsumeResult(messageId, success, failReason, cost));
            return messageLog;
        }

        public String getMessageRecordId() {
            return this.messageRecordId;
        }

        public RecordType getRecordType() {
            return this.recordType;
        }

        public StoreMessageDTO getMessage() {
            return this.message;
        }

        public SendResult getSendResult() {
            return this.sendResult;
        }

        public ConsumeResult getConsumeResult() {
            return this.consumeResult;
        }

        public void setMessageRecordId(String messageRecordId) {
            this.messageRecordId = messageRecordId;
        }

        public void setRecordType(RecordType recordType) {
            this.recordType = recordType;
        }

        public void setMessage(StoreMessageDTO message) {
            this.message = message;
        }

        public void setSendResult(SendResult sendResult) {
            this.sendResult = sendResult;
        }

        public void setConsumeResult(ConsumeResult consumeResult) {
            this.consumeResult = consumeResult;
        }
    }

    public static class ConsumeResult
    implements Serializable {
        private static final long serialVersionUID = 4138074636938525916L;
        private String messageId;
        private Boolean success;
        private String failReason;
        private Long cost;
        private String appCode;
        private String ip;

        public ConsumeResult(String messageId, Boolean success, String failReason, Long cost) {
            this.messageId = messageId;
            this.success = success;
            this.failReason = failReason;
            this.cost = cost;
            this.appCode = CloudtAppHolder.getAppCode();
            this.ip = CloudtAppHolder.getServerIp();
        }

        public ConsumeResult() {
        }

        public String getMessageId() {
            return this.messageId;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public String getFailReason() {
            return this.failReason;
        }

        public Long getCost() {
            return this.cost;
        }

        public String getAppCode() {
            return this.appCode;
        }

        public String getIp() {
            return this.ip;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        public void setFailReason(String failReason) {
            this.failReason = failReason;
        }

        public void setCost(Long cost) {
            this.cost = cost;
        }

        public void setAppCode(String appCode) {
            this.appCode = appCode;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }
    }

    public static class SendResult
    implements Serializable {
        private static final long serialVersionUID = 1240072421383000690L;
        private String messageId;
        private Boolean success;
        private String failReason;

        public SendResult(String messageId, Boolean success, String failReason) {
            this.messageId = messageId;
            this.success = success;
            this.failReason = failReason;
        }

        public SendResult() {
        }

        public String getMessageId() {
            return this.messageId;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public String getFailReason() {
            return this.failReason;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        public void setFailReason(String failReason) {
            this.failReason = failReason;
        }
    }

    public static enum RecordType {
        INIT,
        UPDATE_SEND_RESULT,
        UPDATE_CONSUME_RESULT;

    }
}

