/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support.queue.messagechannel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.mq.common.BaseMessage;
import com.elitescloud.boot.mq.common.MessageQueueStorage;
import com.elitescloud.boot.mq.config.CloudtMqProperties;
import com.elitescloud.boot.mq.config.support.queue.AbstractMqProvider;
import com.elitescloud.boot.provider.TenantClientProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.MutableMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class MessageChannelMqProvider
extends AbstractMqProvider {
    private static final Logger logger = CloudtBootLoggerFactory.MQ_MSGCHANNEL.getLogger(MessageChannelMqProvider.class);
    private final CloudtMqProperties properties;
    private final StreamBridge streamBridge;

    public MessageChannelMqProvider(CloudtMqProperties properties, List<MessageQueueStorage> queueStorageList, TenantClientProvider tenantClientProvider, StreamBridge streamBridge) {
        super(properties, queueStorageList, tenantClientProvider);
        this.properties = properties;
        this.streamBridge = streamBridge;
    }

    @Override
    protected void sendMessage(String channel, String messageId, long tenantId, String payload) {
        AbstractIntegrationMessageBuilder messageBuilder = MutableMessageBuilder.withPayload((Object)payload).setHeader("cloudt_message_original_channel", (Object)channel).setHeader("cloudt_message_id", (Object)messageId).setHeader("KEYS", (Object)this.obtainMessageKeys(payload, messageId)).setHeader("current_tenant_id", (Object)tenantId);
        Message message = messageBuilder.build();
        String topic = this.obtainTopic(channel);
        boolean res = this.streamBridge.send(topic, (Object)message);
        logger.info("sent MQ message result\uff1a{}->{}, {}", new Object[]{channel, topic, res});
    }

    public void consumer(Message<String> message) {
        MessageHeaders headers = message.getHeaders();
        String originalChannel = (String)headers.get((Object)"cloudt_message_original_channel", String.class);
        String messageId = (String)headers.get((Object)"cloudt_message_id", String.class);
        Object tenantId = headers.get((Object)"current_tenant_id");
        if (!(tenantId instanceof Long)) {
            try {
                tenantId = tenantId == null ? TenantConstant.DEFAULT_TENANT_ID : Long.parseLong(tenantId.toString());
            }
            catch (Exception e) {
                logger.error("\u6d88\u606f\u7684\u79df\u6237ID\u8f6c\u6362\u5f02\u5e38\uff1a{}", tenantId, (Object)e);
                tenantId = TenantConstant.DEFAULT_TENANT_ID;
            }
        }
        super.consumeMessage(originalChannel, messageId, (Long)tenantId, (String)message.getPayload());
    }

    protected <T extends Serializable> String obtainMessageKeys(T payload, String messageId) {
        Object businessKey;
        ArrayList<String> keys = new ArrayList<String>(4);
        keys.add(messageId);
        if (payload instanceof BaseMessage) {
            String businessKey2 = ((BaseMessage)payload).getBusinessKey();
            if (CharSequenceUtil.isNotBlank((CharSequence)businessKey2)) {
                keys.add(businessKey2);
            }
        } else if (payload instanceof Map && (businessKey = ((Map)((Object)payload)).get("businessKey")) instanceof String && CharSequenceUtil.isNotBlank((CharSequence)((String)businessKey))) {
            keys.add((String)businessKey);
        }
        return String.join((CharSequence)" ", keys);
    }

    protected String obtainTopic(String channel) {
        String topic = null;
        if (CollUtil.isNotEmpty(this.properties.getTopicMappings())) {
            for (CloudtMqProperties.TopicMapping topicMapping : this.properties.getTopicMappings()) {
                if (!topicMapping.getChannels().contains(channel)) continue;
                topic = topicMapping.getTopic();
            }
        }
        if (CharSequenceUtil.isBlank(topic)) {
            topic = CharSequenceUtil.blankToDefault((CharSequence)this.properties.getTopicDefault(), (String)"cloudt_message_delegate_channel");
        }
        return CharSequenceUtil.blankToDefault((CharSequence)this.properties.getTopicPrefix(), (String)"") + topic;
    }
}

