/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support.queue.messagechannel;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import org.slf4j.Logger;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;

public class CustomPublishSubscribeErrorChannel
extends PublishSubscribeChannel {
    private static final Logger logger = CloudtBootLoggerFactory.MQ_MSGCHANNEL.getLogger(CustomPublishSubscribeErrorChannel.class);

    public boolean send(@NonNull Message<?> message, long timeout) {
        return this.onSendError(message);
    }

    public boolean send(@NonNull Message<?> message) {
        return this.onSendError(message);
    }

    private boolean onSendError(Message<?> message) {
        if (!(message instanceof ErrorMessage)) {
            logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25!");
            return true;
        }
        ErrorMessage errorMessage = (ErrorMessage)message;
        if (!(errorMessage.getPayload() instanceof MessagingException)) {
            logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a", (Throwable)errorMessage.getPayload());
            return true;
        }
        MessagingException exp = (MessagingException)errorMessage.getPayload();
        logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a", exp.getCause());
        return true;
    }
}

